package com.rocogz.syy.oilc.dto.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/4/13 16:30</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@ApiModel("调用分销下单结果更新")
public class CallScmResultUpdateDto {
    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    @NotEmpty
    private String orderCode;

    /**
     * 调用分销下单是否成功
     */
    @ApiModelProperty("调用分销下单是否成功")
    @NotNull
    private Boolean callScmSuccess;

    /**
     * 调用分销下单返回的数据
     */
    @ApiModelProperty("调用分销下单返回的数据")
    private String callScmRes;

    /**
     * 调用分销的时间
     */
    @ApiModelProperty("调用分销的时间")
    private LocalDateTime callScmTime;

    /**
     * 分销订单编号
     */
    @ApiModelProperty("分销订单编号")
    private String scmOrderCode;
}
