package com.rocogz.syy.oilc.dto.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 订单消费券参数DTO
 * @see com.rocogz.syy.oilc.entity.OilcOrderConsumeCoupon
 * @Author 陈煜敏
 * @Date 2022/8/20 11:26
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
@ApiModel("订单消费券参数DTO")
public class OrderConsumeCouponDto {

    /**
     * 用户券编号
     */
    @ApiModelProperty("用户券编号")
    private String userCouponCode;

    /**
     * 用户券的核销码
     */
    @ApiModelProperty("用户券的核销码")
    private String redeemCode;

    /**
     * 券的使用金额
     */
    @ApiModelProperty("券的使用金额")
    private BigDecimal amount;

}
