package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.oilc.constant.OilCConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订单消费券的记录表
 * @author 陈煜敏
 * @since 2022-08-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_order_consume_coupon")
public class OilcOrderConsumeCoupon extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String orderCode;

    /**
     * 用户券编号
     */
    @ApiModelProperty("用户券编号")
    private String userCouponCode;

    /**
     * 用户券的核销码
     */
    @ApiModelProperty("用户券的核销码")
    private String redeemCode;

    /**
     * 券的使用金额
     */
    @ApiModelProperty("券的使用金额")
    private BigDecimal amount;

    /**
     * 状态：已使用、已退回
     * @see OilCConstant.OrderConsumeCouponStatus#USED
     */
    @ApiModelProperty("状态：已使用、已退回")
    private String status;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 退回时间
     */
    @ApiModelProperty("退回时间")
    private LocalDateTime rejectTime;

}
