package com.rocogz.syy.oilc.enumeration;

import lombok.Getter;

/**
 * @author djt
 * @date 2021/11/17
 */
public enum OrderOperationTypeEnum {
    /**
     * 创建
     */
    CREATE("创建"),

    /**
     * 取消
     */
    CANCEL("取消"),

    /**
     * 删除
     */
    DELETE("删除"),

    /**
     * 支付失败
     */
    PAY_FAIL("支付失败"),

    /**
     * 支付成功
     */
    PAY("支付成功"),

    /**
     * 分销下单成功
     */
    CALL_SCM_SUCCESS("分销下单成功"),

    /**
     * 更新上游订单信息
     */
    UPDATE_SCM_ORDER_INFO("更新上游订单信息"),

    /**
     * 充值成功
     */
    RECHARGE_SUCCESS("充值成功"),

    /**
     * 分销上游下单失败导致充值失败
     */

    RECHARGE_FAIL("充值失败"),

    /**
     * 使用核销
     */
    USE("使用核销"),

    /**
     * 过期
     */
    EXPIRE("过期"),

    /**
     * 申请退款
     */
    REFUND_APPLY("申请退款"),

    /**
     * 退款
     */
    REFUND("退款"),

    /**
     * 退款成功
     */
    REFUND_SUCCESS("退款成功"),

    /**
     * 退款失败
     */
    REFUND_FAIL("退款失败"),

    /**
     * 退款
     */
    RECALL("撤回"),

    /**
     * 撤回成功
     */
    RECALL_SUCCESS("撤回成功");

    OrderOperationTypeEnum(String label){
        this.label=label;
    }

    @Getter
    private String label;


}
