package com.rocogz.syy.oilc.dto.order;

import com.rocogz.syy.oilc.dto.order.validate.group.order.ValidateOrderGroup;
import com.rocogz.syy.oilc.dto.order.validate.group.order.ValidateQiaopaiOrderGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/4/8 16:58</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@ApiModel("创建订单参数DTO")
public class CreateOrderDto {
    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @NotEmpty(message = "渠道编码不可为空", groups = {ValidateOrderGroup.class, ValidateQiaopaiOrderGroup.class})
    private String channelCode;

    /**
     * 油站 Id
     */
    @ApiModelProperty("油站 Id")
    private String gasId;

    /**
     * 用户唯一标识
     */
    @ApiModelProperty("用户唯一标识")
    @NotEmpty(message = "用户唯一标识不可为空", groups = {ValidateOrderGroup.class})
    private String userId;

    /**
     * 外部订单编号
     */
    @ApiModelProperty("外部订单编号")
    @NotEmpty(message = "外部订单编号不可为空", groups = {ValidateOrderGroup.class})
    private String outOrderCode;

    /**
     * 油卡充值金额
     */
    @ApiModelProperty("油卡充值金额")
    @NotNull(message = "油卡充值金额", groups = {ValidateOrderGroup.class, ValidateQiaopaiOrderGroup.class})
    private BigDecimal rechargeAmount;

    /**
     * 油卡充值手机号
     */
    @ApiModelProperty("油卡充值手机号")
    @NotEmpty(message = "油卡充值手机号不可为空", groups = {ValidateOrderGroup.class, ValidateQiaopaiOrderGroup.class})
    private String rechargeMobile;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 渠道优惠券编码
     */
    @ApiModelProperty("渠道优惠券编码")
    private String channelDiscountCouponCode;

    /**
     * 渠道优惠金额
     */
    @ApiModelProperty("渠道优惠金额")
    private BigDecimal channelDiscountAmount;

    /**
     * 机构会员优惠比例，如优惠 20%，则传 20, 最多两位小数
     */
    @ApiModelProperty("机构会员优惠比例，如优惠 20%，则传 20, 最多两位小数")
    private BigDecimal orgVipDiscount;


    /*------------------延长壳牌相关字段 start------------------*/

    /**
     * 壳牌油站编号 【壳牌加油】
     */
    @NotEmpty(message = "油站编号不可为空", groups = {ValidateQiaopaiOrderGroup.class})
    @ApiModelProperty("油站编号")
    private String oilStation;

    /**
     * 壳牌油站名称 【壳牌加油】
     */
    @ApiModelProperty("油站名称")
    private String oilStationName;

    /**
     * 壳牌油站地址 【壳牌加油】
     */
    @ApiModelProperty("油站地址")
    private String oilDetailAddress;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    @ApiModelProperty("油枪编号")
    @NotEmpty(message = "油枪编号不可为空", groups = {ValidateQiaopaiOrderGroup.class})
    private String oilGun;

    /**
     * 壳牌油枪名称 【壳牌加油】
     */
    @ApiModelProperty("油枪名称")
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    @ApiModelProperty("油品、油号的编号")
    @NotEmpty(message = "油品、油号编号不可为空", groups = {ValidateQiaopaiOrderGroup.class})
    private String oilNo;

    /**
     * 壳牌油品、油号名称：例如：95#【壳牌加油】
     */
    @ApiModelProperty("油品、油号名称")
    private String oilNoName;

    /**
     * 壳牌油品单价,核销使用时,实时更新壳牌油品单价
     * 积分兑换的商品订单：油品单价传入
     */
    @Digits(integer = 8, fraction=2, message = "油品单价格式不正确", groups = {ValidateQiaopaiOrderGroup.class})
    @DecimalMin(value = "0.00", message = "油品单价格式不正确", groups = {ValidateQiaopaiOrderGroup.class})
    @NotNull(message = "油品单价不可为空", groups = {ValidateQiaopaiOrderGroup.class})
    @ApiModelProperty("油品单价")
    private BigDecimal oilUnitPrice;

    /**
     * 加油升数,例如：5.6L
     */
    @Digits(integer = 8, fraction=2, message = "加油升数格式不正确", groups = {ValidateQiaopaiOrderGroup.class})
    @DecimalMin(value = "0.00", message = "加油升数格式不正确", groups = {ValidateQiaopaiOrderGroup.class})
    @NotNull(message = "加油升数不可为空", groups = {ValidateQiaopaiOrderGroup.class})
    @ApiModelProperty("加油升数")
    private BigDecimal oilVolume;

    /*------------------延长壳牌相关字段 end  ------------------*/

    /**
     * 微信用户的openId
     */
    @ApiModelProperty("微信用户的openId")
    String openId;


    /**
     * 用户勾选的优惠券列表
     * 不勾选的情况允许传空数组或者null
     */
    @ApiModelProperty("用户勾选的优惠券列表")
    List<OrderConsumeCouponDto> consumeCouponList;

}
