package com.rocogz.syy.oilc.dto.order;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-06-02 17:01</dd>
 * <dd>@author：yinshihao</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class OrderPayQueryDto {
    /**
     * 支付记录编号(oilc)
     */
    private String payCode;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 外部订单编号
     */
    private String outOrderCode;

    /**
     * 交易流水号(以下都是第三方支付的字段)
     */
    private String tradeId;

    /**
     * 交易类型，1消费、2撤销、3退货、4预授权、5预授权完成、6预授权撤销、7预授权完成撤销
     */
    private String tradeTypeId;

    /**
     * 交易状态，1开始交易、2交易成功、3交易失败、5未确定
     */
    private String tradeStatus;

    /**
     * 创建开始时间
     */
    private String createTimeStart;

    /**
     * 创建结束时间
     */
    private String createTimeEnd;

    private Integer page = 1;
    private Integer limit = 10;
}
