package com.rocogz.syy.oilc.dto.tenpay;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 返回统一下单结果用于前端调起微信支付</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/6/28 10:07</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class WxPayUnifiedOrderResultDto {

    //微信支付小程序调起API文档： https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=7_7&index=5

    /**
     * 时间戳从1970年1月1日00:00:00至今的秒数,即当前的时间.
     */
    private String timeStamp;

    /**
     * 随机字符串，长度为32个字符以下。
     */
    private String nonceStr;

    /**
     * 统一下单接口返回的 prepay_id 参数值
     */
    private String prepayId;

    /**
     * 签名类型，默认为MD5，支持HMAC-SHA256和MD5。注意此处需与统一下单的签名类型一致
     */
    private String signType;

    /**
     * 签名
     */
    private String paySign;

    /**
     * roco车服订单编号(不参与签名).
     */
    private String rocoTradeNo;

    /**
     * 用于前端判断是否需要调起微信支付, 默认为true
     */
    private Boolean needWxPay = true;

    /**
     * 拼接package作为前端返回，
     */
    public String getPackage(){
        return "prepay_id="+getPrepayId();
    }

}
