package com.rocogz.syy.oilc.constant;

/**
 * The type Outside oil order rabbit constant.
 */
public class OilcRabbitConstant {

    /**
     * 通用exchange
     */
    public static final String OILC_EXCHANGE = "OILC_EXCHANGE";

    /**
     * 第三方支付 退款 状态查询消息 延时队列
     */
    public static final String PLUTUS_REFUND_QUERY_DELAY_QUEUE = "PLUTUS_REFUND_QUERY_DELAY_QUEUE";

    /**
     * 第三方支付 退款 状态查询消息 延时队列 KEY
     */
    public static final String PLUTUS_REFUND_QUERY_DELAY_QUEUE_KEY = "PLUTUS_REFUND_QUERY_DELAY_QUEUE_KEY";

    /**
     * 第三方支付 退款 状态查询消息 死信队列
     */
    public static final String PLUTUS_REFUND_QUERY_DEAD_QUEUE = "PLUTUS_REFUND_QUERY_DEAD_QUEUE";

    /**
     * 第三方支付 退款 状态查询消息 死信队列 KEY
     */
    public static final String PLUTUS_REFUND_QUERY_DEAD_QUEUE_KEY = "PLUTUS_REFUND_QUERY_DEAD_QUEUE_KEY";

    /**
     * 订单状态变更回调平安 队列
     */
    public static final String ORDER_STATUS_CHANGE_CALL_PA_QUEUE = "ORDER_STATUS_CHANGE_CALL_PA_QUEUE";

    /**
     * 订单状态变更回调平安 队列 KEY
     */
    public static final String ORDER_STATUS_CHANGE_CALL_PA_QUEUE_KEY = "ORDER_STATUS_CHANGE_CALL_PA_QUEUE_KEY";


    /**
     * C端加油 超时取消订单 延时队列
     */
    public static final String OILC_ORDER_TIMEOUT_DELAY_QUEUE = "OILC_ORDER_TIMEOUT_DELAY_QUEUE";

    /**
     * C端加油 超时取消订单 延时队列 KEY
     */
    public static final String OILC_ORDER_TIMEOUT_DELAY_QUEUE_KEY = "OILC_ORDER_TIMEOUT_DELAY_QUEUE_KEY";

    /**
     * C端加油 超时取消订单 死信队列
     */
    public static final String OILC_ORDER_TIMEOUT_DELAY_DEAD_QUEUE = "OILC_ORDER_TIMEOUT_DELAY_DEAD_QUEUE";

    /**
     * C端加油 超时取消订单 死信队列 KEY
     */
    public static final String OILC_ORDER_TIMEOUT_DELAY_QUEUE_DEAD_KEY = "OILC_ORDER_TIMEOUT_DELAY_QUEUE_DEAD_KEY";


    /**
     * 分销供应链上游下单重试 mq配置
     */
    public static final String SCM_EXCHANGE = "SCM_EXCHANGE";
    public static final String SCM_REORDER_QUEEN_ROUTE_KEY = "SCM_REORDER_QUEEN_ROUTE_KEY";


    private OilcRabbitConstant() {
    }
}
