package com.rocogz.syy.oilc.dto.order;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 实时计算价格接口的传参</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/6/1 16:56</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class CalculateAmountReq {
    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 油号，如：92
     */
    private String oilNo;

    /**
     * 订单金额。单元：元。如 200
     */
    private BigDecimal amountOrder;

    /**
     * 机构会员优惠比例，如优惠 20%，则传 20, 最多两位小数
     */
    private BigDecimal orgVipDiscount;
}
