package com.rocogz.syy.oilc.dto.order;

import com.rocogz.syy.oilc.entity.OilcOrder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 退款申请列表返回
 * </p>
 *
 * @author yinshihao
 * @since 2022-06-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class OrderPageRespDto extends OilcOrder {

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 发放主体简称
     */
    private String issuingBodyAbbreviation;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 有效期开始日期字符串(前端只展示日期不展示时间)
     */
    private String validityPeriodStartTimeStr;

    /**
     * 有效期结束日期字符串(前端只展示日期不展示时间)
     */
    private String validityPeriodEndTimeStr;

}
