package com.rocogz.syy.oilc.dto.order;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/4/20 16:42</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class WxPayInfoDto {

    //微信支付小程序调起API文档： https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=7_7&index=5

    /**
     * 时间戳从1970年1月1日00:00:00至今的秒数,即当前的时间.
     */
    private String timeStamp;

    /**
     * 随机字符串，长度为32个字符以下。
     */
    private String nonceStr;

    /**
     * 统一下单接口返回的 prepay_id 参数值
     */
    private String prepayId;

    /**
     * 签名类型，默认为MD5，支持HMAC-SHA256和MD5。注意此处需与统一下单的签名类型一致
     */
    private String signType;

    /**
     * 签名
     */
    private String paySign;
}
