package com.rocogz.syy.oilc.dto.product;

import com.rocogz.syy.oilc.dto.order.OrderConsumeCouponDto;
import com.rocogz.syy.oilc.dto.order.validate.group.order.ValidateOrderGroup;
import com.rocogz.syy.oilc.dto.order.validate.group.order.ValidateQiaopaiOrderGroup;
import com.rocogz.syy.oilc.entity.OilcProductAppId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/4/8 16:58</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@ApiModel("更新产品平台appId关系参数DTO")
public class UpdateProductAppIdDto {
    /**
     * 渠道编码
     */
    @ApiModelProperty("产品编码")
    @NotEmpty(message = "产品编码不可为空")
    private String productCode;

    /**
     * 用户选择的平台列表
     */
    @ApiModelProperty("用户选择的平台列表")
    List<OilcProductAppId> productAppIdList;

}
