package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单支付信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_order_pay")
public class OilcOrderPay extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 支付记录对应的微信用户的openid(oilc)
     */
    private String wxOpenid;

    /**
     * 支付记录编号(oilc)
     */
    private String payCode;

    /**
     * 加油订单编号(oilc)
     */
    private String orderCode;

    /**
     * 外部加油订单编号(oilc、平安订单编号)
     */
    private String outOrderCode;

    /**
     * 交易流水号(以下都是第三方支付的字段)
     */
    private String tradeId;

    /**
     * 第三方交易流水号，不长于30位，第三方全局唯一
     */
    private String outTransId;

    /**
     * 交易类型，1消费、2撤销、3退货、4预授权、5预授权完成、6预授权撤销、7预授权完成撤销
     */
    private Integer tradeTypeId;

    /**
     * 交易金额，单位：元
     */
    private BigDecimal tradeAmount;

    /**
     * 银行优惠金额，单位：元
     */
    private BigDecimal bankOffsetAmount;

    /**
     * 实收金额，单位：元
     */
    private BigDecimal receiveAmount;

    /**
     * 交易时间
     */
    private LocalDateTime tradeTime;

    /**
     * 交易状态，1开始交易、2交易成功、3交易失败、5未确定
     */
    private Integer tradeStatus;

    /**
     * 会员卡号
     */
    private String merberCard;

    /**
     * 交易结果
     */
    private String payResult;

    /**
     * 支付类型，0默认、1001现金、1003微信、1004支付宝、1006银行卡、1010银联扫码、1012翼支付、1014龙支付、1015分期支付
     */
    private Integer payTypeId;

    /**
     * 支付卡号
     */
    private String payAccount;

    /**
     * 渠道商户编号
     */
    private String merchantCode;

    /**
     * 渠道终端编号
     */
    private String terminalCode;

    /**
     * 设备号、虚拟设备号
     */
    private String sn;

    /**
     * 手续费
     */
    private BigDecimal fee;

    /**
     * 第三方收银号
     */
    private String caseierPayNo;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
