package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 产品与平台appId关系表
 * </p>
 *
 * @author 陈煜敏
 * @since 2022-011-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_product_appid")
public class OilcProductAppId extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 产品名称
     */
    @TableField(exist=false)
    private String productName;

    /**
     * 平台appId
     */
    private String appId;

    /**
     * 平台名称
     */
    private String appName;

    /**
     * 服务平台编号
     */
    private String servicePlatformCode;

    /**
     * 服务平台名称
     */
    @TableField(exist=false)
    private String servicePlatformName;

    /**
     * 服务平台状态
     */
    @TableField(exist=false)
    private String platformStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
