package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 退款申请表
 * </p>
 *
 * @author yinshihao
 * @since 2022-06-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_order_refund_apply")
public class OilcOrderRefundApply extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 申请单审核状态(PENDING:待审批、PASS:审批通过、REFUSE:审批不通过、FAIL:退款失败、PROCESSED:已退款)
     */
    private String status;

    /**
     * 退款记录编号
     */
    private String refundCode;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 申请时间
     */
    private LocalDateTime applyTime;

    /**
     * 申请人账号
     */
    private String applyUser;

    /**
     * 申请人手机号
     */
    private String applyUserMobile;

    /**
     * 审核人
     */
    private String examineUser;

    /**
     * 审核时间
     */
    private LocalDateTime examineTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 申请备注
     */
    private String applyRmk;

    /**
     * 审核描述
     */
    private String examineDescription;

    /**
     * 订单信息
     */
    @TableField(exist = false)
    private OilcOrder oilcOrder;

    /**
     * 订单退款信息
     */
    @TableField(exist = false)
    private OilcOrderRefund oilcOrderRefund;
}
