package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 产品表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-04-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_product")
public class OilcProduct extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 产品编码
     */
    private String code;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 渠道名称
     */
    @TableField(exist = false)
    private String channelName;

    /**
     * 渠道对应的发放主体编码
     */
    @TableField(exist = false)
    private String issuingBodyCode;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 产品面额
     */
    private BigDecimal faceValue;

    /**
     * 产品单价
     */
    private BigDecimal unitPrice;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
