package com.rocogz.syy.oilc.enumeration;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 订单交易状态
 * 交易状态，1开始交易、2交易成功、3交易失败、5未确定
 * @see com.rocogz.syy.oilc.dto.plutuspay.PlutusTradeDetail#tradeStatus
 * @Author 陈煜敏
 * @Date 2022/8/25 10:50
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
public enum OrderTradeEnum {

    /**
     * 开始交易
     */
    TRADE_START(1, "开始交易"),

    /**
     * 交易成功
     */
    TRADE_SUCCESS(2, "交易成功"),

    /**
     * 交易失败
     */
    TRADE_FAIL(3, "交易失败"),

    /**
     * 未确定
     */
    TRADE_ERROR(5, "未确定");


    OrderTradeEnum(int code, String label){
        this.code=code;
        this.label=label;
    }

    @Getter
    private int code;

    @Getter
    private String label;

    public static OrderTradeEnum findByCode(int code){
        Optional<OrderTradeEnum> result = Arrays.stream(values()).filter(item -> item.code == code).findFirst();
        return result.orElse(TRADE_ERROR);
    }

}
