/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.oilc.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.oilc.dto.dailyPrice.AddPriceConfigDto;
import com.rocogz.syy.oilc.dto.jms.PlutusRefundResultQueryMsg;
import com.rocogz.syy.oilc.dto.order.CalculateAmountBatchReq;
import com.rocogz.syy.oilc.dto.order.CalculateAmountBatchResp;
import com.rocogz.syy.oilc.dto.order.CalculateAmountReq;
import com.rocogz.syy.oilc.dto.order.CalculateAmountResp;
import com.rocogz.syy.oilc.dto.order.CallScmResultUpdateDto;
import com.rocogz.syy.oilc.dto.order.CancelOderDto;
import com.rocogz.syy.oilc.dto.order.CreateOrderDto;
import com.rocogz.syy.oilc.dto.order.CreateOrderRespDto;
import com.rocogz.syy.oilc.dto.order.OilcOrderUsedSuccessDto;
import com.rocogz.syy.oilc.dto.order.OrderPageRespDto;
import com.rocogz.syy.oilc.dto.order.OrderPayQueryDto;
import com.rocogz.syy.oilc.dto.order.OrderQueryDto;
import com.rocogz.syy.oilc.dto.order.OrderRefundDto;
import com.rocogz.syy.oilc.dto.order.OrderStatusChangeDto;
import com.rocogz.syy.oilc.dto.order.OrderUsedNotifyDto;
import com.rocogz.syy.oilc.dto.order.RechargeSuccessNotifyDto;
import com.rocogz.syy.oilc.dto.order.RefundApplyApproveReqDto;
import com.rocogz.syy.oilc.dto.order.RefundApplyPageRespDto;
import com.rocogz.syy.oilc.dto.order.RefundApplyQueryDto;
import com.rocogz.syy.oilc.dto.order.WxPayInfoDto;
import com.rocogz.syy.oilc.dto.order.WxPayReq;
import com.rocogz.syy.oilc.dto.plutuspay.PlutusNotify;
import com.rocogz.syy.oilc.entity.OilcChannel;
import com.rocogz.syy.oilc.entity.OilcOilPriceConfig;
import com.rocogz.syy.oilc.entity.OilcOilPriceDaily;
import com.rocogz.syy.oilc.entity.OilcOrder;
import com.rocogz.syy.oilc.entity.OilcOrderPay;
import com.rocogz.syy.oilc.entity.OilcOrderRefundApply;
import com.rocogz.syy.oilc.entity.OilcProduct;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IOilCClientService {
    @PostMapping(value={"/oilc/order/cancel"})
    public Response cancelOrder(@RequestBody CancelOderDto var1);

    @GetMapping(value={"/oilc/order/expire"})
    public Response expireOrder(@RequestParam(value="scmOrderItemCode") String var1);

    @PostMapping(value={"/oilc/order/expireOrderBatch"})
    public Response expireOrderBatch(@RequestBody List<String> var1);

    @GetMapping(value={"/oilc/order/{orderCode}"})
    public Response<OilcOrder> getOrder(@PathVariable(name="orderCode") String var1);

    @GetMapping(value={"/oilc/order/query"})
    public Response<OilcOrder> simpleQuery(@RequestParam(value="orderCode", required=false) String var1, @RequestParam(value="outOrderCode", required=false) String var2);

    @PostMapping(value={"/oilc/order/callScmResultUpdate"})
    public Response callScmResultUpdate(@RequestBody CallScmResultUpdateDto var1);

    @PostMapping(value={"/oilc/order/rechargedSuccessNotify"})
    public Response rechargedSuccessNotify(@RequestBody RechargeSuccessNotifyDto var1);

    @GetMapping(value={"/oilc/order/rechargeFailedNotify"})
    public Response rechargeFailedNotify(@RequestParam(value="scmOrderCode") String var1);

    @GetMapping(value={"/oilc/order/recall"})
    @ApiOperation(value="\u64a4\u56de\u8ba2\u5355")
    public Response recallOrder(@RequestParam(value="orderCode") String var1, @RequestParam(value="operateUser", required=false) String var2);

    @PostMapping(value={"/oilc/orderUserCoupon/checkUserCouopnUsed"})
    public Response<Boolean> checkUserCouopnUsed(@RequestBody List<String> var1);

    @PostMapping(value={"/oilc/orderPay/c/pay"})
    public Response<WxPayInfoDto> pay(@RequestBody WxPayReq var1);

    @PostMapping(value={"/oilc/orderPay/paySuccess"})
    public Response<OilcOrder> paySuccess(@RequestBody PlutusNotify var1);

    @PostMapping(value={"/oilc/orderPay/orderPayPageQuery"})
    public PageTable<OilcOrderPay> orderPayPageQuery(@RequestBody OrderPayQueryDto var1);

    @PostMapping(value={"/oilc/orderPay/getOrderPayTotalCount"})
    public Response<Integer> getOrderPayTotalCount(@RequestBody OrderPayQueryDto var1);

    @PostMapping(value={"/oilc/order/c/createOrder"})
    public Response<CreateOrderRespDto> createOrder(@RequestBody CreateOrderDto var1);

    @GetMapping(value={"/oilc/order/findFailOrderList"})
    public Response<List<OilcOrder>> findFailOrderList();

    @GetMapping(value={"/oilc/order/scheduleRetryCreateScmOrderOfFailedOrder"})
    public Response scheduleRetryCreateScmOrderOfFailedOrder();

    @PostMapping(value={"/oilc/order/refund"})
    public Response refund(@RequestBody OrderRefundDto var1);

    @PostMapping(value={"/oilc/order/statusChange"})
    public Response statusChange(@Validated @RequestBody OrderStatusChangeDto var1);

    @GetMapping(value={"/oilc/oilPriceDaily/c/list"})
    public Response<List<OilcOilPriceDaily>> listOilPrice();

    @PostMapping(value={"/oilc/orderRefund/updateRefundResult"})
    public Response updateRefundResult(@RequestBody PlutusRefundResultQueryMsg var1);

    @PostMapping(value={"/oilc/order/usedNotify"})
    public Response<OilcOrderUsedSuccessDto> usedNotify(@RequestBody OrderUsedNotifyDto var1);

    @PostMapping(value={"/oilc/order/orderPageQuery"})
    public PageTable<OrderPageRespDto> orderPageQuery(@RequestBody OrderQueryDto var1);

    @PostMapping(value={"/oilc/order/getOrderTotalCount"})
    public Response<Integer> getOrderTotalCount(@RequestBody OrderQueryDto var1);

    @PostMapping(value={"/oilc/orderRefundApply/orderRefundApplyPageQuery"})
    public PageTable<RefundApplyPageRespDto> orderRefundApplyPageQuery(@RequestBody RefundApplyQueryDto var1);

    @PostMapping(value={"/oilc/orderRefundApply/createRefundApply"})
    public Response<String> createRefundApply(@RequestBody OilcOrderRefundApply var1);

    @PostMapping(value={"/oilc/orderRefundApply/approveRefundApply"})
    public Response<String> approveRefundApply(@RequestBody RefundApplyApproveReqDto var1);

    @GetMapping(value={"/oilc/orderRefundApply/getRefundApplyByApplyNo"})
    public Response<OilcOrderRefundApply> getRefundApplyByApplyNo(@RequestParam(value="applyNo") String var1);

    @PostMapping(value={"/oilc/orderRefundApply/updateRefundApplyByApplyNo"})
    public Response<Boolean> updateRefundApplyByApplyNo(@RequestBody OilcOrderRefundApply var1);

    @PostMapping(value={"/oilc/orderRefundApply/getRefundApplyTotalCount"})
    public Response<Integer> getRefundApplyTotalCount(@RequestBody RefundApplyQueryDto var1);

    @GetMapping(value={"/oilc/orderRefundApply/getRefundApplyListByOrderCode"})
    public Response<List<OilcOrderRefundApply>> getRefundApplyListByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/oilc/product/calculateAmount"})
    public Response<CalculateAmountResp> calculateAmount(@RequestBody CalculateAmountReq var1);

    @PostMapping(value={"/oilc/product/calculateAmountBatch"})
    public Response<List<CalculateAmountBatchResp>> calculateAmountBatch(@RequestBody CalculateAmountBatchReq var1);

    @GetMapping(value={"/oilc/channel/list"})
    public PageTable<OilcChannel> selectOilcChannelList(@RequestParam(name="name", required=false) String var1, @RequestParam(name="status", required=false) String var2, @RequestParam(name="issuingBodyCode", required=false) String var3, @RequestParam(name="page", required=false) int var4, @RequestParam(name="limit", required=false) int var5);

    @GetMapping(value={"/oilc/channel/listByCodes"})
    public Response<List<OilcChannel>> selectOilcChannelListByCodes(@RequestParam(name="codes", required=true) String var1);

    @PostMapping(value={"/oilc/channel/addOrUpdate"})
    public Response addOrUpdateOilcChannel(@RequestBody OilcChannel var1);

    @GetMapping(value={"/oilc/oilPriceDaily/list"})
    public Response<List<OilcOilPriceDaily>> selectPriceDailyList();

    @GetMapping(value={"/oilc/oilPriceDaily/config/list/{oilQuality}"})
    public Response<List<OilcOilPriceConfig>> selectOilPriceDailyConfigList(@PathVariable(name="oilQuality") String var1);

    @PostMapping(value={"/oilc/oilPriceDaily/add/config"})
    public Response addOilPriceDailyConfig(@RequestBody AddPriceConfigDto var1);

    @PostMapping(value={"/oilc/oilPriceDaily/del/config/{id}"})
    public Response deletePriceDailyConfigById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/oilc/product/list"})
    public PageTable<OilcProduct> selectOilcProductList(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="customerProductCode", required=false) String var3, @RequestParam(name="customerProductName", required=false) String var4, @RequestParam(name="status", required=false) String var5, @RequestParam(name="page", required=false, defaultValue="1") int var6, @RequestParam(name="limit", required=false, defaultValue="10") int var7);

    @GetMapping(value={"/oilc/product/listByCodes"})
    public Response<List<OilcProduct>> selectOilcProductListByCodes(@RequestParam(name="codes", required=true) String var1);

    @PostMapping(value={"/oilc/product/addOrUpdate"})
    public Response addOrUpdateOilcProduct(@RequestBody OilcProduct var1);

    @PostMapping(value={"/oilc/product/del/{code}"})
    public Response deleteOilcProductByCode(@PathVariable(value="code") String var1);

    @GetMapping(value={"/oilc/oilPriceConfig/listOilPriceConfigQualityNewOne"})
    public Response<List<OilcOilPriceConfig>> listOilPriceConfigQualityNewOne();

    @PostMapping(value={"/oilc/oilPriceDaily/scheduleUpdate"})
    public Response scheduleUpdatePriceDaily();
}

