package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 每日油价
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-04-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_oil_price_daily")
@ApiModel("今日油价信息")
public class OilcOilPriceDaily extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 标号
     */
    @ApiModelProperty("标号")
    private String oilQuality;

    /**
     * 国标价
     */
    @ApiModelProperty("国标价")
    private BigDecimal nationalPrice;

    /**
     * 平台价
     */
    @ApiModelProperty("平台价")
    private BigDecimal platformPrice;

    /**
     * 油站价
     */
    @ApiModelProperty("油站价")
    private BigDecimal gasStationPrice;

    /**
     * 开始生效时间
     */
    @ApiModelProperty("开始生效时间")
    private LocalDate startTime;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createUser;

    /**
     * 更新时间
     */
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    @ApiModelProperty("更新人")
    private String updateUser;
}
