package com.rocogz.syy.oilc.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 油价设置表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-06-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_oil_price_config")
public class OilcOilPriceConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 标号
     */
    private String oilQuality;

    /**
     * 国标价
     */
    private BigDecimal nationalPrice;

    /**
     * 平台价
     */
    private BigDecimal platformPrice;

    /**
     * 油站价
     */
    private BigDecimal gasStationPrice;

    /**
     * 开始生效时间
     */
    private LocalDate startTime;

    /**
     * 状态（已生效：startTime小于当前时间、待生效：startTime大于当前时间）
     */
    @TableField(exist = false)
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;
}
