package com.rocogz.syy.oilc.dto.tenpay;

import com.rocogz.syy.oilc.enumeration.tenpay.TradeTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: WxPayRefundParamDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/28 17:42</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class WxPayRefundParamDto {

    //微信支付申请退款接口API文档： https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_4

    /**
     * 字段名：订单类型.
     * 是否必填：是
     */
    @NotNull
    private TradeTypeEnum rocoTradeType;

    /**
     * 字段名：用户openid.
     * 是否必填：是
     */
    @NotEmpty
    private String openid;

    /**
     * <pre>
     * 字段名：微信支付下单时传入的roco的订单号.
     * 变量名：roco_trade_no
     * 描述：商户侧传给微信的订单号
     * </pre>
     */
    @NotEmpty
    private String rocoTradeNo;

    /**
     * <pre>
     * 字段名：roco内部的退款单号.
     * 变量名：roco_refund_no
     * 是否必填：是
     * 类型：String(32)
     * 描述：商户系统内部的退款单号，商户系统内部唯一，同一退款单号多次请求只退一笔
     * </pre>
     */
    @NotEmpty
    private String rocoRefundNo;

    /**
     * <pre>
     * 字段名：退款金额(元).
     * 变量名：refundAmount
     * 是否必填：是
     * </pre>
     */
    @NotNull
    private BigDecimal refundAmount;

    /**
     * <pre>
     * 字段名：退款原因.
     * 变量名：refund_account
     * 是否必填：否
     * 示例值：商品已售完
     * 描述：若商户传入，会在下发给用户的退款消息中体现退款原因
     * </pre>
     */
    private String refundDesc;

    /**
     * <pre>
     * 字段名：退款结果通知url.
     * 变量名：notify_url
     * 是否必填：否
     * 类型：String(256)
     * 示例值：https://weixin.qq.com/notify/
     * 描述：	异步接收微信支付退款结果通知的回调地址，通知URL必须为外网可访问的url，不允许带参数
     * 如果参数中传了notify_url，则商户平台上配置的回调地址将不会生效。优先级：此处传参 > 项目配置文件配置的 > 商户平台上配置的
     * </pre>
     */
    private String notifyUrl;
}
