package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.oilc.constant.OilCConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-04-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_order")
public class OilcOrder extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String orderCode;

    /**
     * 外部订单编号,平安好车主有外部订单号,壳牌的没有
     */
    @ApiModelProperty("外部订单编号")
    private String outOrderCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 发放主体编码
     */
    @ApiModelProperty("发放主体编码")
    private String issuingBodyCode;

    /**
     * 外部用户标识
     */
    @ApiModelProperty("外部用户标识")
    private String userId;

    /**
     * 油站 Id
     */
    @ApiModelProperty("油站 Id")
    private String gasId;

    /**
     * 产品编号
     *
     * @see OilcProduct#code
     */
    @ApiModelProperty("产品编号")
    private String productCode;

    /**
     * 合作客户产品编码
     */
    @ApiModelProperty("合作客户产品编码")
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    @ApiModelProperty("合作客户产品名称")
    private String customerProductName;

    @ApiModelProperty("平台产品品牌编号")
    private String brandCode;

    /**
     * 油卡充值手机号
     */
    @ApiModelProperty("油卡充值手机号")
    private String rechargeMobile;

    /**
     * 油卡充值金额
     * （1)平安好车主 rechargeAmount = {@link OilcProduct#faceValue}
     * (2)壳牌加油  rechargeAmount = 用户输入的充值金额
     */
    @ApiModelProperty("油卡充值金额")
    private BigDecimal rechargeAmount;

    /**
     * 订单总金额
     * (1)平安好车主  totalAmount = {@link OilcProduct#unitPrice}
     * (2)壳牌加油   totalAmount = 用户输入的充值金额
     */
    @ApiModelProperty("订单总金额")
    private BigDecimal totalAmount;

    /**
     * 订单优惠金额
     * (1)平安好车主 discountAmount = 0
     * （2）壳牌加油  discountAmount = 加油抵扣券金额
     */
    @ApiModelProperty("订单优惠金额")
    private BigDecimal discountAmount;

    /**
     * 渠道优惠券编码
     * 平安好车主那边给的优惠
     */
    @ApiModelProperty("渠道优惠券编码")
    private String channelDiscountCouponCode;

    /**
     * 渠道优惠金额,平安好车主那边给的优惠金额
     * （1) 平安好车主：channelDiscountAmount=0 目前是0
     * (2) 壳牌：   channelDiscountAmount =0
     */
    @ApiModelProperty("渠道优惠金额")
    private BigDecimal channelDiscountAmount;

    /**
     * 需要支付的现金总金额 needPayTotalAmount = totalAmount - discountAmount- channelDiscountAmount
     */
    @ApiModelProperty("需要支付的总金额")
    private BigDecimal needPayTotalAmount;

    /**
     * 已支付现金总金额
     */
    @ApiModelProperty("已支付总金额")
    private BigDecimal payedTotalAmount;

    /**
     * 现金支付时间
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;

    /**
     * 现金支付状态
     */
    @ApiModelProperty("现金支付状态")
    private String payStatus;

    /**
     * 订单状态
     *
     * @see OilCConstant.OrderStatus#PENDING_PAY
     */
    @ApiModelProperty("订单状态")
    private String status;

    /**
     * 第三方调用状态
     * 回调平安后更新
     * @see OilCConstant.OrderCallApiStatus#TYPE_CODE
     */
    @ApiModelProperty("第三方调用状态")
    private String callApiStatus;

    /**
     * 充值完成时间
     */
    @ApiModelProperty("充值完成时间")
    private LocalDateTime rechargeFinishTime;

    /**
     * 使用时间
     */
    @ApiModelProperty("使用时间")
    private LocalDateTime useTime;

    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;

    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDate expireDate;

    /**
     * 调用分销下单是否成功
     */
    private Boolean callScmSuccess;

    /**
     * 调用分销次数
     */
    private Integer callScmCnt;

    /**
     * 最后一次调用分销下单时间
     */
    @ApiModelProperty("最后一次调用分销下单时间")
    private LocalDateTime lastTimeCallScm;

    /**
     * 调用分销下单返回的数据
     */
    private String callScmRes;

    /**
     * 分销下游订单编号
     */
    @ApiModelProperty("分销下游订单编号")
    private String scmOrderCode;

    /**
     * 分销明细订单编号，分销上游订单号
     */
    @ApiModelProperty("分销明细订单编号")
    private String scmOrderItemCode;



    /*------------------延长壳牌相关字段 start------------------*/

    /**
     * 壳牌油站编号 【壳牌加油】
     */
    @ApiModelProperty("油站编号")
    private String oilStation;

    /**
     * 壳牌油站名称 【壳牌加油】
     */
    @ApiModelProperty("油站油站名称")
    private String oilStationName;

    /**
     * 壳牌油站地址 【壳牌加油】
     */
    @ApiModelProperty("油站地址")
    private String oilDetailAddress;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    @ApiModelProperty("油枪编号")
    private String oilGun;

    /**
     * 壳牌油枪名称 【壳牌加油】
     */
    @ApiModelProperty("油枪名称")
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    @ApiModelProperty("油品、油号的编号")
    private String oilNo;

    /**
     * 壳牌油品、油号名称：例如：95#【壳牌加油】
     */
    @ApiModelProperty("油品、油号名称")
    private String oilNoName;

    /**
     * 壳牌油品单价,核销使用时,实时更新壳牌油品单价
     * 积分兑换的商品订单：油品单价传入
     */
    @ApiModelProperty("油品单价")
    private BigDecimal oilUnitPrice;

    /**
     * 加油升数,例如：5.6L
     */
    @ApiModelProperty("加油升数")
    private BigDecimal oilVolume;

    /*------------------延长壳牌相关字段 end  ------------------*/

    /**
     * 平台小程序appId
     */
    @ApiModelProperty("平台小程序appId")
    private String appId;

    /**
     * 收款商户配置id
     */
    @ApiModelProperty("收款商户配置id")
    private String mchId;


    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 是否被逻辑删除
     */
    private boolean deleted;

    /**
     * 有效期开始日期
     */
    private LocalDateTime validityPeriodStartTime;

    /**
     * 有效期结束日期
     */
    private LocalDateTime validityPeriodEndTime;


    /**
     * admin后台是否能够 撤回操作
     */
    public boolean isCanRecall() {
        if (!OilCConstant.OrderPayStatus.PAID.equals(payStatus)) {
            //没有付款，直接返回false,不能撤回
            return false;
        }

        if (isShellOrder()) {
            //壳牌的
            if (OilCConstant.OrderStatus.USED.equals(status)) {
                return true;
            } else {
                return false;
            }

        } else {
            //平安好车主的,
            if (OilCConstant.OrderStatus.RECHARGE_SUCCESS.equals(status) || (OilCConstant.OrderStatus.EXPIRED.equals(status) && getUseTime() == null)) {
                return true;
            } else {
                return false;
            }
        }
    }


    public boolean isShellOrder() {
        return OilCConstant.OILC_ORDER_BAND_CODE_SHEL.equalsIgnoreCase(this.brandCode);
    }
}