package com.rocogz.common.api.response;

import com.rocogz.common.api.enums.ResponseEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Andrew
 * @create 2020/2/4 9:06 下午
 */
@Data
public class CommonResponse<T> implements Serializable {

    private T result;

    private String code;

    private String message;

    public boolean isSuccess() {
        return ResponseEnum.isSuccess(code);
    }

    private static CommonResponse getResponse(ResponseEnum responseCode) {
        CommonResponse response = new CommonResponse();
        response.setCode(responseCode.getCode());
        response.setMessage(responseCode.getMessage());
        return response;
    }

    public static CommonResponse success(Object result) {
        CommonResponse response = getResponse(ResponseEnum.SUCCESS);
        if (null != result) {
            response.setResult(result);
        }
        return response ;
    }

}
