package com.rocogz.common.api.request;

import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 主键id 通用参数
 *
 * @author Andrew
 * @create 2020/2/20 10:52 上午
 */

@Data
@Builder
public class BasePrimaryKeyRequest implements Serializable {
    @NotNull
    @Min(1)
    private Long id;


    public static CommonRequest<BasePrimaryKeyRequest> buildCommonRequest(Long id) {
        return CommonRequest.build(BasePrimaryKeyRequest.builder().id(id).build());
    }

}
