package com.rocogz.common.api.request;

import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Tolerate;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
@Data
@Builder
@ToString(callSuper = true)
public class CommonQueryPageRequest<T> implements Serializable {

    @Valid
    @NotNull
    private T request;

    @NotNull
    @Min(value = 1)
    private Integer pageNum;

    @NotNull
    @Min(value = 1)
    private Integer pageSize;


    @Tolerate
    public CommonQueryPageRequest() {}


    public static <T> CommonQueryPageRequest<T> build(T request, Integer pageNum, Integer pageSize) {
        return CommonQueryPageRequest.<T>builder().request(request).pageNum(pageNum).pageSize(pageSize).build();
    }

}
