package com.rocogz.common.api.request;

import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import lombok.experimental.Tolerate;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;


/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
@Data
@SuperBuilder
@Builder
@ToString(callSuper = true)
public class CommonQueryPageRequest<T> extends CommonRequest<T> {


    @NotNull
    @Min(value = 1)
    private Integer pageNum;

    @NotNull
    @Min(value = 1)
    private Integer pageSize;


    @Tolerate
    public CommonQueryPageRequest() {
    }


    public static <T> CommonQueryPageRequest<T> build(T request, Integer pageNum, Integer pageSize) {
        return CommonQueryPageRequest.<T>builder().pageNum(pageNum).pageSize(pageSize).request(request).build();
    }

}
