package com.rocogz.common.api.request;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import lombok.experimental.Tolerate;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Andrew
 * @create 2020/4/7 2:36 下午
 */

@Data
@SuperBuilder
@Builder
public class CommonRequest<T> implements Serializable {
    @Valid
    @NotNull
    private T request;


    public static <T> CommonRequest<T> build(T request) {
        return CommonRequest.<T>builder().request(request).build();
    }

    @Tolerate
    public CommonRequest() {}


}
