package com.rocogz.common.api.request;

import lombok.Data;
import lombok.ToString;
import lombok.experimental.Tolerate;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;


/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
@Data
@ToString(callSuper = true)
public class CommonQueryPageRequest<T> extends CommonRequest<T> {


    @NotNull
    @Min(value = 1)
    private Integer pageNum;

    @NotNull
    @Min(value = 1)
    private Integer pageSize;


    public static <T> CommonQueryPageRequest<T> build(T request, Integer pageNum, Integer pageSize) {
        CommonQueryPageRequest<T> commonQueryPageRequest = new CommonQueryPageRequest();
        commonQueryPageRequest.setPageNum(pageNum);
        commonQueryPageRequest.setPageSize(pageSize);
        commonQueryPageRequest.setRequest(request);
        return commonQueryPageRequest;
    }

}
