package com.rocogz.common.api.request;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 * 唯一编码
 * @author Andrew
 * @create 2020/4/7 5:47 下午
 */
@Data
@Builder
public class BaseUniqueCodeRequest implements Serializable {

    @NotBlank
    private String code;

    @Tolerate
    public BaseUniqueCodeRequest() {
    }

    public static CommonRequest<BaseUniqueCodeRequest> buildCommonRequest(String code) {
        return CommonRequest.build(BaseUniqueCodeRequest.builder().code(code).build());
    }
}
