/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.dubbo.filter;

import com.google.common.collect.Sets;
import com.rocogz.common.api.enums.ResponseEnum;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.util.RpcContextUtils;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class AuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String auth = RpcContextUtils.getAuth();
        if (StringUtils.isNotBlank((CharSequence)auth)) {
            log.info("auth:{}", (Object)auth);
            Set<String> permissions = RpcContextUtils.getPermissions();
            if (!permissions.contains("*") && !permissions.containsAll(Sets.newHashSet((Object[])auth.split(","))) && invocation instanceof RpcInvocation) {
                RpcInvocation rpcInvocation = (RpcInvocation)invocation;
                try {
                    Object resp = rpcInvocation.getReturnType().newInstance();
                    CommonResponse authResp = new CommonResponse();
                    authResp.setCode(ResponseEnum.AUTH_ERROR.getCode());
                    authResp.setMessage(ResponseEnum.AUTH_ERROR.getMessage());
                    BeanUtils.copyProperties((Object)authResp, resp);
                    return AsyncRpcResult.newDefaultAsyncResult(resp, (Invocation)invocation);
                }
                catch (Exception e) {
                    throw new RpcException(Integer.valueOf(ResponseEnum.AUTH_ERROR.getCode()).intValue(), ResponseEnum.AUTH_ERROR.getMessage(), (Throwable)e);
                }
            }
        }
        return invoker.invoke(invocation);
    }
}

