package com.rocogz.common.dubbo.filter;

import com.google.common.collect.Sets;
import com.rocogz.common.api.enums.ResponseEnum;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.util.RpcContextUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.*;
import org.springframework.beans.BeanUtils;

import java.util.Set;

/**
 * 权限校验
 *
 * @author Andrew
 * @create 2020/2/20 4:45 下午
 */
@Slf4j
public class AuthFilter implements Filter {

    private static final String TOTAL ="*";
    private static final String SPLIT =",";


    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String auth = RpcContextUtils.getAuth();
        if (StringUtils.isNotBlank(auth)) {
            log.info("auth:{}", auth);
            Set<String> permissions = RpcContextUtils.getPermissions();
            if (!permissions.contains(TOTAL) && !permissions.containsAll(Sets.newHashSet(auth.split(SPLIT)))) {
                if (invocation instanceof RpcInvocation) {
                    RpcInvocation rpcInvocation = (RpcInvocation) invocation;
                    try {
                        Object resp = rpcInvocation.getReturnType().newInstance();
                        CommonResponse authResp = new CommonResponse();
                        authResp.setCode(ResponseEnum.AUTH_ERROR.getCode());
                        authResp.setMessage(ResponseEnum.AUTH_ERROR.getMessage());
                        BeanUtils.copyProperties(authResp, resp);
                        return AsyncRpcResult.newDefaultAsyncResult(resp, invocation);
                    } catch (Exception e) {
                        throw new RpcException(Integer.valueOf(ResponseEnum.AUTH_ERROR.getCode()), ResponseEnum.AUTH_ERROR.getMessage(), e);
                    }
                }

            }
        }
        return invoker.invoke(invocation);
    }
}
