/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.template;

import com.github.pagehelper.PageSerializable;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.util.ExceptionUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSinglePageTemplate<Request, DATA> {
    private static final Logger log = LoggerFactory.getLogger(BaseSinglePageTemplate.class);

    public CommonQueryPageResponse<DATA> call(CommonQueryPageRequest<Request> request) {
        try {
            PageSerializable<DATA> pageInfo = this.callInner(request);
            return CommonQueryPageResponse.success((List)pageInfo.getList(), (long)pageInfo.getTotal(), (int)this.getPages(pageInfo.getTotal(), request));
        }
        catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    public int getPages(long total, CommonQueryPageRequest request) {
        int pageSize = request.getPageSize();
        return (int)(total / (long)pageSize + (long)(total % (long)pageSize == 0L ? 0 : 1));
    }

    protected abstract PageSerializable<DATA> callInner(CommonQueryPageRequest<Request> var1) throws Exception;
}

