/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.dubbo.filter;

import com.rocogz.common.util.LogUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class DubboLogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboLogFilter.class);
    private static final String BEFORE_LOG_MSG = "Calling  service[{}.{}][{}].Sent request:{}.";
    private static final String AFTER_LOG_MSG = "Called  service[{}.{}].[{}]. elapsed:[{} Seconds] ";

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        LogUtils.initReqLog();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.doLogBefore(invoker, invocation);
        Result result = invoker.invoke(invocation);
        stopWatch.stop();
        this.doLogAfter(invoker, invocation, result.getValue(), stopWatch.getTotalTimeSeconds());
        LogUtils.clearReqLog();
        return result;
    }

    private void doLogBefore(Invoker<?> invoker, Invocation invocation) {
        log.info(BEFORE_LOG_MSG, new Object[]{invoker.getInterface().getSimpleName(), invocation.getMethodName(), invoker.getUrl().getAddress(), invocation.getArguments()});
    }

    private void doLogAfter(Invoker<?> invoker, Invocation invocation, Object response, Double elapsed) {
        String clazzName = invoker.getInterface().getSimpleName();
        String methodName = invocation.getMethodName();
        log.info(AFTER_LOG_MSG, new Object[]{clazzName, methodName, response == null ? null : response.toString(), elapsed});
    }
}

