package com.rocogz.common.util;



import com.rocogz.common.api.enums.ResponseEnum;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.exception.BizException;
import com.rocogz.common.exception.ParamException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.util.CollectionUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import java.util.Set;

/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
@Slf4j
public class ExceptionUtils {

    public static CommonResponse handle(CommonRequest request, Exception e) {
        Object[] result = handleException(request, e);
        CommonResponse response = new CommonResponse();
        response.setCode(result[0].toString());
        response.setMessage(result[1].toString());
        response.setResult(result[2]);
        return response;
    }

    public static CommonQueryPageResponse handle(CommonQueryPageRequest request, Exception e) {
        Object[] result = handleException(request, e);
        CommonQueryPageResponse response = new CommonQueryPageResponse();
        response.setCode(result[0].toString());
        response.setMessage(result[1].toString());
        return response;
    }

    private static Object[] handleException(Object req, Exception e) {
        String code = ResponseEnum.SYSTEM_ERROR.getCode();
        String message = ResponseEnum.SYSTEM_ERROR.getMessage();
        Object data = null;
        if (e instanceof IllegalArgumentException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof ParamException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof DuplicateKeyException) {
            log.error("唯一索引: req[{}]", req, ResponseEnum.DUPLICATE_ERROR.getMessage(), e);
            code = ResponseEnum.DUPLICATE_ERROR.getCode();
            message = ResponseEnum.DUPLICATE_ERROR.getMessage();
        } else if (e instanceof BizException) {
            log.error("业务异常: req[{}]", req, e);
            code = ResponseEnum.BIZ_ERROR.getCode();
            message = e.getMessage();
            data = ((BizException) e).getData();
        } else {
            message = e.getMessage() == null ? e.toString(): e.getMessage();
            log.error("系统异常: req[{}]:", req, e);
        }
        return new Object[]{code, message, data};
    }


    public static void valid(Validator validator, Object obj) {
        Set<ConstraintViolation<Object>> set = validator.validate(obj);
        if (!CollectionUtils.isEmpty(set)) {
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation v : set) {
                msg.append(v.getPropertyPath()).append(":").append(v.getMessage()).append(",");
            }
            msg.delete(msg.length() - 1, msg.length());
            throw new ParamException(msg.toString());
        }
    }

}
