package com.rocogz.common.mybatis.interceptor;

import com.rocogz.common.util.RpcContextUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanMap;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;

import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * 用户信息拦截器 自动设置用户信息
 *
 * @author Andrew
 * @create 2020/2/20 9:26 上午
 */

@Slf4j
@Intercepts({
        @Signature(
                type = Executor.class,
                method = "update",
                args = {MappedStatement.class, Object.class}
        )}
)
public class UserInfoInterceptor implements Interceptor {

    private static final String INSERT = ".insert";
    private static final String UPDATE = ".updateByPrimaryKey";
    private static final String UPDATE_SELECTIVE = ".updateByPrimaryKeySelective";
    private static final String UPDATE_EXAMPLE = ".updateByExample";
    private static final String UPDATE_EXAMPLE_SELECTIVE = ".updateByExampleSelective";


    public UserInfoInterceptor() {
        log.info("初始化组件:[Mybatis自动注入用户信息]");
    }

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        try {
            MappedStatement ms = (MappedStatement) args[0];
            Object parameter = args[1];
            Map replaceParameter = null;
            if (ms.getId().endsWith(INSERT)) {
                //如果是插入， 则赋值其 用户信息创建信息
                replaceParameter = replaceInsertUserInfo(new BeanMap(parameter));
            } else if (ms.getId().endsWith(UPDATE) || ms.getId().endsWith(UPDATE_SELECTIVE)) {
                //如果是修改， 则赋值其 用户信息修改信息
                replaceParameter = replaceUpdateUserInfo(new BeanMap(parameter));
            } else if (ms.getId().endsWith(UPDATE_EXAMPLE) || ms.getId().endsWith(UPDATE_EXAMPLE_SELECTIVE)) {
                if (parameter instanceof MapperMethod.ParamMap) {
                    MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap) parameter;
                    Object record = paramMap.get("record");
                    Map newParam = replaceUpdateUserInfo(new BeanMap(record));
                    if (newParam != null) {
                        paramMap.put("record", newParam);
                    }
                }
            }
            if (replaceParameter != null) {
                args[1] = replaceParameter;
            }
        } catch (Exception e) {
            log.error("设置用户信息异常", e);
        }
        return method.invoke(target, args);
    }


    private Map<Object, Object> replaceUpdateUserInfo(Map<Object, Object> paramMap) {
        Set<Boolean> replaceFlag = new HashSet<>();
        replace(replaceFlag, paramMap, "updateUser", RpcContextUtils.getUserId());
        replace(replaceFlag, paramMap, "updateUsertype", RpcContextUtils.getUserType());
        replace(replaceFlag, paramMap, "updateName", RpcContextUtils.getChineseName());
        replace(replaceFlag, paramMap, "updateUserName", RpcContextUtils.getChineseName());
        replace(replaceFlag, paramMap, "updateDate", LocalDate.now());
        replace(replaceFlag, paramMap, "updateTime", LocalDateTime.now());
        if (replaceFlag.contains(true)) {
            log.info("replaceUpdateUserInfo");
            return paramMap;
        }
        return null;
    }

    private Map<Object, Object> replaceInsertUserInfo(Map<Object, Object> paramMap) {
        Set<Boolean> replaceFlag = new HashSet<>();
        replace(replaceFlag, paramMap, "createUser", RpcContextUtils.getUserId());
        replace(replaceFlag, paramMap, "createUsertype", RpcContextUtils.getUserType());
        replace(replaceFlag, paramMap, "createName", RpcContextUtils.getChineseName());
        replace(replaceFlag, paramMap, "createUserName", RpcContextUtils.getChineseName());
        replace(replaceFlag, paramMap, "createDate", LocalDate.now());
        replace(replaceFlag, paramMap, "createTime", LocalDateTime.now());
        if (replaceFlag.contains(true)) {
            log.info("replaceInsertUserInfo");
            return paramMap;
        }
        return null;
    }

    private void replace(Set<Boolean> booleanSet, Map<Object, Object> paramMap, String key, Object val) {
        if (paramMap.containsKey(key) && paramMap.get(key) == null) {
            paramMap.put(key, val);
            log.info("set {}:{}", key, val);
            booleanSet.add(true);
        }
        booleanSet.add(false);
    }


    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
