package com.rocogz.common.template;


import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.util.ExceptionUtils;
import com.rocogz.common.util.ReqUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.Validator;

/**
 * 事务模板
 *
 * @author Andrew
 * @create 2020/2/21 2:52 下午
 */
@Slf4j
public abstract class BaseTransactionalTemplate<Request, Result> {

    @Autowired
    private Validator validator;

    public CommonResponse<Result> call(CommonRequest<Request> request) {
        try {
            ExceptionUtils.valid(validator, request);
            Object proxy = AopContext.currentProxy();
            Result result = (Result) ((BaseTransactionalTemplate)proxy).callTransactional(request);
            return CommonResponse.success(result);
        } catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    /**
     * 调用内部服务的方法
     *
     * @param request
     * @return
     * @throws Exception
     */
    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRED)
    public abstract Result callTransactional(CommonRequest<Request> request) throws Exception;


    public Result callService(CommonRequest commonRequest, Request request) throws Exception {
        log.info("callService: req [{}]", request);
        ExceptionUtils.valid(validator, request);
        CommonRequest<Request> innerReq = ReqUtils.converterReq(commonRequest, request);
        Object proxy = AopContext.currentProxy();
        Result result = (Result) ((BaseTransactionalTemplate)proxy).callTransactional(innerReq);
        log.info("callService: res [{}]", result);
        return result;
    }
}
