/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.lock;

import com.rocogz.common.lock.AbstractDistributedLock;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisDistributedLock
extends AbstractDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private StringRedisTemplate redisTemplate;
    private ThreadLocal<String> lockFlag = new ThreadLocal();

    public RedisDistributedLock(StringRedisTemplate redisTemplate) {
        log.info("\u521d\u59cb\u5316\u7ec4\u4ef6:[\u5206\u5e03\u5f0f\u9501]");
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean lock(String key, long expire, int retryTimes, long sleepMillis) {
        log.info("lock [{} : {} - {} - {} ]", new Object[]{key, expire, retryTimes, sleepMillis});
        boolean result = this.setRedis(key, expire);
        while (!Thread.currentThread().isInterrupted() && !result && retryTimes-- > 0) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("get lock occured an exception,", (Throwable)e);
                return false;
            }
            result = this.setRedis(key, expire);
            log.debug("retry get [{}] lock: {} ,remaining times: {}", new Object[]{key, result, retryTimes});
        }
        return result;
    }

    @Override
    public boolean releaseLock(String key) {
        log.info("releaseLock:[{}]", (Object)key);
        boolean result = false;
        try {
            if (this.lockFlag.get() != null && this.lockFlag.get().equals(this.redisTemplate.opsForValue().get((Object)key))) {
                this.redisTemplate.delete((Object)key);
                this.lockFlag.remove();
                log.debug("release [{}] lock", (Object)key);
            }
            result = true;
        }
        catch (Exception e) {
            log.error("release lock occured an exception", (Throwable)e);
        }
        return result;
    }

    private boolean setRedis(String key, long expire) {
        boolean result = false;
        try {
            this.lockFlag.set(UUID.randomUUID().toString());
            result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)this.lockFlag.get(), expire, TimeUnit.MILLISECONDS);
            if (result) {
                log.debug("lock [{}] expire: {}ms", (Object)key, (Object)expire);
            }
        }
        catch (Exception e) {
            log.error("set redis occured an exception", (Throwable)e);
        }
        log.debug("get [{}] lock: {}", (Object)key, (Object)result);
        return result;
    }
}

