/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.lock;

import cn.hutool.core.util.IdUtil;
import com.google.common.collect.Sets;
import com.rocogz.common.lock.AbstractDistributedLock;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisDistributedLock
extends AbstractDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private StringRedisTemplate redisTemplate;
    private ThreadLocal<Set<String>> lockFlag = new ThreadLocal();

    public RedisDistributedLock(StringRedisTemplate redisTemplate) {
        log.info("\u521d\u59cb\u5316\u7ec4\u4ef6:[\u5206\u5e03\u5f0f\u9501]");
        this.redisTemplate = redisTemplate;
    }

    private synchronized void initLockFlag() {
        if (this.lockFlag.get() == null) {
            this.lockFlag.set(Sets.newHashSet());
        }
    }

    private String setAndGetFlag() {
        this.initLockFlag();
        String flag = IdUtil.fastSimpleUUID();
        boolean result = this.lockFlag.get().add(flag);
        log.info("[ThreadLocal] add flag:[{}], result:[{}] -> [{}]", new Object[]{flag, result, this.lockFlag.get()});
        return flag;
    }

    private synchronized boolean removeFlag(String flag) {
        boolean result = false;
        if (this.lockFlag.get() != null) {
            result = this.lockFlag.get().remove(flag);
        }
        log.info("[ThreadLocal] remove flag:[{}], result:[{}] -> [{}]", new Object[]{flag, result, this.lockFlag.get()});
        return result;
    }

    @Override
    public boolean lock(String key, long expire, int retryTimes, long sleepMillis) {
        log.info("lock [{} : {} - {} - {} ]", new Object[]{key, expire, retryTimes, sleepMillis});
        boolean result = this.setRedis(key, expire);
        while (!Thread.currentThread().isInterrupted() && !result && retryTimes-- > 0) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("get lock occured an exception,", (Throwable)e);
                return false;
            }
            result = this.setRedis(key, expire);
            log.info("retry get [{}] lock: {} ,remaining times: {}", new Object[]{key, result, retryTimes});
        }
        return result;
    }

    @Override
    public boolean releaseLock(String key) {
        boolean result = false;
        Set<String> flags = this.lockFlag.get();
        if (CollectionUtils.isEmpty(flags)) {
            log.info("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u9501");
            result = true;
        } else {
            String flag = (String)this.redisTemplate.opsForValue().get((Object)key);
            if (StringUtils.isBlank((CharSequence)flag)) {
                log.info("\u9501\u5df2\u8fc7\u671f");
                result = true;
            } else if (this.removeFlag(flag)) {
                result = this.redisTemplate.delete((Object)key);
            } else {
                log.error("\u975e\u672c\u7ebf\u7a0b\u9501\uff0c\u4e0d\u53ef\u5220\u9664");
            }
        }
        log.info("releaseLock:[{}], result:[{}]", (Object)key, (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRedis(String key, long expire) {
        boolean result = false;
        String flag = this.setAndGetFlag();
        try {
            result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)flag, expire, TimeUnit.MILLISECONDS);
            if (result) {
                log.debug("lock [{}] expire: {}ms", (Object)key, (Object)expire);
            }
        }
        catch (Exception e) {
            log.error("set redis occured an exception", (Throwable)e);
        }
        finally {
            if (!result) {
                this.removeFlag(flag);
            }
        }
        log.debug("get [{}] lock: {}", (Object)key, (Object)result);
        return result;
    }
}

