package com.rocogz.common.template;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.util.ExceptionUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.Validator;
import java.util.List;


/**
 * 分页查询服务模版
 * @param <Request> 请求
 * @param <DO> 对应数据库DO
 * @author Andrew
 * @create 2020/2/5 10:04 上午
 */
@Slf4j
public abstract class BaseQueryPageTemplate<Request, DO> {


    @Autowired
    private Validator validator;

    public CommonQueryPageResponse<DO> call(CommonQueryPageRequest<Request> request) {
        try {
            ExceptionUtils.valid(validator, request);
            PageHelper.startPage(request.getPageNum(), request.getPageSize());
            List<DO> list = callInner(request);
            PageInfo pageInfo = new PageInfo(list);
            return CommonQueryPageResponse.success(list, pageInfo.getTotal(), pageInfo.getPages());
        }  catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }


    /**
     * 内部调用查询数据库的方法
     * @param request 查询的条件
     * @return 返回查询的结果
     * @throws Exception
     */
    protected abstract List<DO> callInner(CommonQueryPageRequest<Request> request) throws Exception;

}
