package com.rocogz.common.util;

import cn.hutool.core.util.StrUtil;
import com.rocogz.common.api.constant.RpcConstant;
import org.apache.dubbo.rpc.RpcContext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Andrew
 * @create 2020/2/4 10:26 下午
 */
public class RpcContextUtils {


    public static String getUserId() {
        return RpcContext.getContext().getAttachment(RpcConstant.USER_ID);
    }

    public static String getUsername() {
        return RpcContext.getContext().getAttachment(RpcConstant.USER_NAME);
    }

    public static String getChineseName() {
        return RpcContext.getContext().getAttachment(RpcConstant.CHINESE_NAME);
    }

    public static String getUserType() {
        return RpcContext.getContext().getAttachment(RpcConstant.USER_TYPE);
    }

    public static Set<String> getPermissions() {
        String permissions = RpcContext.getContext().getAttachment(RpcConstant.PERMISSIONS);
        if (StrUtil.isNotBlank(permissions)) {
            return new HashSet<String>(Arrays.asList(permissions.split(",")));
        }
        return new HashSet<String>();
    }

    public static String getAuth() {
        return RpcContext.getContext().getAttachment(RpcConstant.AUTH);
    }

    public static String getTraceId() {
        return RpcContext.getContext().getAttachment(RpcConstant.TRACE_ID);
    }


}
