package com.rocogz.common.template;


import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.util.ExceptionUtils;
import com.rocogz.common.util.ReqUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.Validator;

/**
 * 单个服务模版
 *
 * @param <Request> 请求
 * @param <Result>  结果
 * @author Andrew
 * @create 2020/2/5 10:04 上午
 */
@Slf4j
public abstract class BaseSingleTemplate<Request, Result> {

    @Autowired
    private Validator validator;

    public CommonResponse<Result> call(CommonRequest<Request> request) {
        try {
            Class[] groups = setCheckGroups();
            ExceptionUtils.valid(validator, request, groups);
            Result result = callInner(request);
            return CommonResponse.success(result);
        } catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    /**
     * 调用内部服务的方法
     *
     * @param request
     * @return
     * @throws Exception
     */
    protected abstract Result callInner(CommonRequest<Request> request) throws Exception;
    
    /**
     * 设置分组校验
     * @return
     */
    protected Class[] setCheckGroups() {
        return new Class[]{};
    }
    
    public Result callService(CommonRequest commonRequest, Request request) throws Exception {
        log.info("callService: req [{}]", request);
        ExceptionUtils.valid(validator, request);
        CommonRequest<Request> innerReq = ReqUtils.converterReq(commonRequest, request);
        Result result = callInner(innerReq);
        log.info("callService: res [{}]", result);
        return result;
    }
}
