/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.lock;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import com.google.common.collect.Sets;
import com.rocogz.common.lock.AbstractDistributedLock;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisDistributedLock
extends AbstractDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private static final String LOCK_VAL_DELIMITER = "@";
    private StringRedisTemplate redisTemplate;
    private ThreadLocal<Set<String>> lockFlag = new ThreadLocal();

    public RedisDistributedLock(StringRedisTemplate redisTemplate) {
        log.info("\u521d\u59cb\u5316\u7ec4\u4ef6:[\u5206\u5e03\u5f0f\u9501]");
        this.redisTemplate = redisTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(String key, long expire, int retryCount, long sleepMillis) {
        boolean result;
        block6: {
            log.info("\u3010Lock start: [{}]\u3011 >>  expire:[{} ms], retryCount:[{}], interval:[{} ms]", new Object[]{key, expire, retryCount, sleepMillis});
            String flag = this.setAndGetFlag(key);
            result = false;
            try {
                result = this.setRedis(key, expire, flag);
                while (!Thread.currentThread().isInterrupted() && !result && retryCount-- > 0) {
                    log.info("\u3010Lock sleep: [{} ms]\u3011] ", (Object)sleepMillis);
                    try {
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e) {
                        log.error("redis\u9501\u5f02\u5e38:[{}]", (Object)key, (Object)e);
                        break;
                    }
                    log.info("\u3010Lock retry: [{}]\u3011>> remain:[{}]", (Object)key, (Object)retryCount);
                    result = this.setRedis(key, expire, flag);
                }
                if (result) break block6;
                this.removeFlag(flag);
            }
            catch (Throwable throwable) {
                if (!result) {
                    this.removeFlag(flag);
                }
                log.info("\u3010Lock end: [{}]\u3011 >>  expire:[{} ms], result:[{}]", new Object[]{key, expire, result});
                throw throwable;
            }
        }
        log.info("\u3010Lock end: [{}]\u3011 >>  expire:[{} ms], result:[{}]", new Object[]{key, expire, result});
        return result;
    }

    @Override
    public boolean releaseLock(String key) {
        log.info("\u3010Release Lock start: [{}]\u3011", (Object)key);
        Assert.notBlank((CharSequence)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean result = false;
        Set<String> flags = this.lockFlag.get();
        if (CollectionUtils.isEmpty(flags)) {
            log.info("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u9501");
            result = true;
        } else {
            String flag = (String)this.redisTemplate.opsForValue().get((Object)key);
            if (StringUtils.isBlank((CharSequence)flag)) {
                log.info("\u3010Lock Expired : [{}]\u3011", (Object)key);
                result = this.removeFlagByRedisKey(key);
            } else if (this.removeFlag(flag)) {
                result = this.redisTemplate.delete((Object)key);
            } else {
                log.error("\u975e\u672c\u7ebf\u7a0b\u9501\uff0c\u4e0d\u53ef\u5220\u9664");
            }
        }
        log.info("\u3010Release Lock end: [{}]\u3011 >> result:[{}]", (Object)key, (Object)result);
        return result;
    }

    private boolean setRedis(String key, long expire, String value) {
        boolean result = expire > 0L ? this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, expire, TimeUnit.MILLISECONDS).booleanValue() : this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value).booleanValue();
        return result;
    }

    private boolean removeFlagByRedisKey(String redisKey) {
        Set<String> flags = this.lockFlag.get();
        if (CollectionUtils.isNotEmpty(flags) && StringUtils.isNotBlank((CharSequence)redisKey)) {
            for (String flag : flags) {
                String key = flag.split(LOCK_VAL_DELIMITER)[0];
                if (!key.equals(redisKey)) continue;
                return this.removeFlag(flag);
            }
        }
        return false;
    }

    private synchronized void initLockFlag() {
        if (this.lockFlag.get() == null) {
            this.lockFlag.set(Sets.newHashSet());
        }
    }

    private String setAndGetFlag(String redisKey) {
        Assert.notBlank((CharSequence)redisKey, (String)"redisKey \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((!redisKey.contains(LOCK_VAL_DELIMITER) ? 1 : 0) != 0, (String)"\u6682\u4e0d\u652f\u6301key\u540d\u79f0\u643a\u5e26\u7b26\u53f7:{}", (Object[])new Object[]{LOCK_VAL_DELIMITER});
        this.initLockFlag();
        String flag = String.join((CharSequence)LOCK_VAL_DELIMITER, redisKey, IdUtil.fastSimpleUUID());
        boolean result = this.lockFlag.get().add(flag);
        log.info("[ThreadLocal] add flag:[{}], result:[{}] -> [{}]", new Object[]{flag, result, this.lockFlag.get()});
        return flag;
    }

    private synchronized boolean removeFlag(String flag) {
        boolean result = false;
        Set<String> flagSet = this.lockFlag.get();
        if (flagSet != null) {
            result = flagSet.remove(flag);
            if (flagSet.isEmpty()) {
                this.lockFlag.remove();
            }
        }
        log.info("[ThreadLocal] remove flag:[{}], result:[{}] -> [{}]", new Object[]{flag, result, this.lockFlag.get()});
        return result;
    }
}

