/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.template;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.util.ExceptionUtils;
import com.rocogz.common.util.ReqUtils;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseTransactionalTemplate<Request, Result> {
    private static final Logger log = LoggerFactory.getLogger(BaseTransactionalTemplate.class);
    @Autowired
    private Validator validator;

    public CommonResponse<Result> call(CommonRequest<Request> request) {
        try {
            Class[] groups = this.setCheckGroups();
            ExceptionUtils.valid(this.validator, request, groups);
            Object proxy = AopContext.currentProxy();
            Result result = ((BaseTransactionalTemplate)proxy).callTransactional(request);
            return CommonResponse.success(result);
        }
        catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public abstract Result callTransactional(CommonRequest<Request> var1) throws Exception;

    protected Class[] setCheckGroups() {
        return new Class[0];
    }

    public Result callService(CommonRequest commonRequest, Request request) throws Exception {
        log.info("callService: req [{}]", request);
        Class[] groups = this.setCheckGroups();
        ExceptionUtils.valid(this.validator, request, groups);
        CommonRequest<Request> innerReq = ReqUtils.converterReq(commonRequest, request);
        Object proxy = AopContext.currentProxy();
        Result result = ((BaseTransactionalTemplate)proxy).callTransactional(innerReq);
        log.info("callService: res [{}]", result);
        return result;
    }
}

