/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.template;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.util.ExceptionUtils;
import java.util.List;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseTransitionQueryPageTemplate<Request, Result, TransRequest, TransResult> {
    private static final Logger log = LoggerFactory.getLogger(BaseTransitionQueryPageTemplate.class);
    @Autowired
    private Validator validator;

    public CommonQueryPageResponse<Result> call(CommonQueryPageRequest<Request> request) {
        try {
            Class[] groups = this.setCheckGroups();
            ExceptionUtils.valid(this.validator, request, groups);
            TransRequest transReq = this.transformRequest(request.getRequest());
            PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
            List<TransResult> list = this.callInner(transReq);
            PageInfo pageInfo = new PageInfo(list);
            List<Result> result = this.transformerResponse(list);
            return CommonQueryPageResponse.success(result, (long)pageInfo.getTotal(), (int)pageInfo.getPages());
        }
        catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    protected Class[] setCheckGroups() {
        return new Class[0];
    }

    protected abstract List<TransResult> callInner(TransRequest var1) throws Exception;

    protected abstract TransRequest transformRequest(Request var1);

    protected abstract List<Result> transformerResponse(List<TransResult> var1);
}

