/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.util;

import com.rocogz.common.api.enums.ResponseEnum;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.exception.BizException;
import com.rocogz.common.exception.ParamException;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.util.CollectionUtils;

public class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public static CommonResponse handle(CommonRequest request, Exception e) {
        Object[] result = ExceptionUtils.handleException(request, e);
        CommonResponse response = new CommonResponse();
        response.setCode(result[0].toString());
        response.setMessage(result[1].toString());
        response.setResult(result[2]);
        return response;
    }

    public static CommonQueryPageResponse handle(CommonQueryPageRequest request, Exception e) {
        Object[] result = ExceptionUtils.handleException(request, e);
        CommonQueryPageResponse response = new CommonQueryPageResponse();
        response.setCode(result[0].toString());
        response.setMessage(result[1].toString());
        return response;
    }

    private static Object[] handleException(Object req, Exception e) {
        String code = ResponseEnum.SYSTEM_ERROR.getCode();
        String message = ResponseEnum.SYSTEM_ERROR.getMessage();
        Object data = null;
        if (e instanceof IllegalArgumentException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof ParamException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof DuplicateKeyException) {
            log.error("\u552f\u4e00\u7d22\u5f15: req[{}]", new Object[]{req, ResponseEnum.DUPLICATE_ERROR.getMessage(), e});
            code = ResponseEnum.DUPLICATE_ERROR.getCode();
            message = ResponseEnum.DUPLICATE_ERROR.getMessage();
        } else if (e instanceof BizException) {
            log.error("\u4e1a\u52a1\u5f02\u5e38: req[{}]", req, (Object)e);
            code = ResponseEnum.BIZ_ERROR.getCode();
            message = e.getMessage();
            data = ((BizException)e).getData();
        } else {
            message = e.getMessage() == null ? e.toString() : e.getMessage();
            log.error("\u7cfb\u7edf\u5f02\u5e38: req[{}]:", req, (Object)e);
        }
        return new Object[]{code, message, data};
    }

    public static void valid(Validator validator, Object obj, Class<?> ... groups) {
        Set set = validator.validate(obj, (Class[])groups);
        if (!CollectionUtils.isEmpty((Collection)set)) {
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation v : set) {
                msg.append(v.getPropertyPath()).append(":").append(v.getMessage()).append(",");
            }
            msg.delete(msg.length() - 1, msg.length());
            throw new ParamException(msg.toString());
        }
    }
}

