package com.rocogz.common.dubbo.filter;

import com.alibaba.fastjson.JSON;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.HashMap;
import java.util.Map;

/**
 * 泛化调用转换对象过滤器
 *
 * @author Andrew
 * @create 2020/2/18 5:22 下午
 */
@Service
@Slf4j
public class GenericConvertFilter implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object[] params = invocation.getArguments();
        if (params != null && params.length == 1) {
            Object param = params[0];
            Object newParam = null;
            try {
                if (param instanceof CommonRequest) {
                    newParam = getConvertReq((CommonRequest) param);
                } else if (param instanceof CommonQueryPageRequest) {
                    newParam = getConvertReq((CommonQueryPageRequest) param);
                }
            } catch (Exception e) {
                throw new RuntimeException("接口配置异常", e);
            }
            if (newParam != null) {
                RpcInvocation rpcInvocation = new RpcInvocation(invocation);
                rpcInvocation.setArguments(new Object[]{param});
                return invoker.invoke(rpcInvocation);
            }

        }
        return invoker.invoke(invocation);
    }


    private Object getConvertReq(CommonRequest commonRequest) throws Exception {
        Object request = commonRequest.getRequest();
        if (request != null && request instanceof HashMap) {
            commonRequest.setRequest(getConvertReq((HashMap) request));
            return commonRequest;
        }
        return null;
    }

    private Object getConvertReq(CommonQueryPageRequest commonRequest) throws Exception {
        Object request = commonRequest.getRequest();
        if (request != null && request instanceof HashMap) {
            commonRequest.setRequest(getConvertReq((HashMap) request));
            return commonRequest;
        }
        return null;
    }

    private Object getConvertReq(Map<String, Object> reqMap) throws Exception {
        Object clazz = reqMap.get("class");
        log.info("Convert:{}", clazz);
        Assert.notNull(clazz, "接口配置错误");

        Object reqParam = reqMap.get("reqJson");
        Assert.notNull(reqParam, "请求错误");

        String reqJson = reqParam.toString();

        Object newReq = JSON.parseObject(reqJson, Class.forName(clazz.toString()));

        return newReq;
    }
}
