package com.rocogz.common.template;

import com.github.pagehelper.PageSerializable;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.util.ExceptionUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.Validator;

/**
 * 手动实现分页
 *
 * @author Andrew
 * @create 2020/3/1 4:45 下午
 */
@Slf4j
public abstract class BaseSinglePageTemplate<Request, DATA> {

    @Autowired
    private Validator validator;

    public CommonQueryPageResponse<DATA> call(CommonQueryPageRequest<Request> request) {
        try {
            Class[] groups = setCheckGroups();
            ExceptionUtils.valid(validator, request, groups);
            PageSerializable pageInfo = callInner(request);
            return CommonQueryPageResponse.success(pageInfo.getList(), pageInfo.getTotal(), getPages(pageInfo.getTotal(), request));
        } catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }
    
    /**
     * 设置分组校验
     * @return
     */
    protected Class[] setCheckGroups() {
        return new Class[]{};
    }
    

    public int getPages(long total, CommonQueryPageRequest request) {
        int pageSize = request.getPageSize();
        return (int) (total / (long) pageSize + (long) (total % (long) pageSize == 0L ? 0 : 1));
    }


    /**
     * 组装查询返回
     *
     * @param request 查询的条件
     * @return 返回查询的结果
     * @throws Exception
     */
    protected abstract PageSerializable<DATA> callInner(CommonQueryPageRequest<Request> request) throws Exception;
}
