package com.rocogz.common.template;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.util.ExceptionUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.Validator;
import java.util.List;


/**
 * 分页查询服务模版
 * @param <Request> 请求
 * @param <Result> 响应
 *
 * @author Andrew
 * @create 2020/2/5 10:04 上午
 */
@Slf4j
public abstract class BaseTransitionQueryPageTemplate<Request, Result, QueryRequest, DO> {

    @Autowired
    private Validator validator;
    
    public CommonQueryPageResponse<Result> call(CommonQueryPageRequest<Request> request) {
        try {
            Class[] groups = setCheckGroups();
            ExceptionUtils.valid(validator, request, groups);
            //请求转换
            QueryRequest transReq = transformRequest(request.getRequest());
            PageHelper.startPage(request.getPageNum(), request.getPageSize());
            List<DO> list = callInner(CommonQueryPageRequest.build(transReq, request.getPageNum(), request.getPageSize()));
            PageInfo pageInfo = new PageInfo(list);
            List<Result> result = transformerResponse(list);
            return CommonQueryPageResponse.success(result, pageInfo.getTotal(), pageInfo.getPages());
        }  catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }
    
    /**
     * 设置分组校验
     * @return
     */
    protected Class[] setCheckGroups() {
        return new Class[]{};
    }
    
    
    /**
     * 内部调用查询数据库的方法
     * @param request 查询的条件
     * @return 返回查询的结果
     * @throws Exception
     */
    protected abstract List<DO> callInner(CommonQueryPageRequest<QueryRequest> request) throws Exception;
    
    
    /**
     * 转换请求
     * @param req
     * @return 转换请求对象
     */
    protected abstract QueryRequest transformRequest(Request req);
    
    
    /**
     * 转换响应
     * @param resp
     * @return 转换后的结果
     */
    protected abstract List<Result> transformerResponse(List<DO> resp);
    
}
