/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.mybatis.interceptor;

import com.rocogz.common.util.RpcContextUtils;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.beanutils.BeanMap;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class UserInfoInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(UserInfoInterceptor.class);
    private static final String INSERT = ".insert";
    private static final String INSERT_LIST = ".insertList";
    private static final String UPDATE = ".updateByPrimaryKey";
    private static final String UPDATE_SELECTIVE = ".updateByPrimaryKeySelective";
    private static final String UPDATE_EXAMPLE = ".updateByExample";
    private static final String UPDATE_EXAMPLE_SELECTIVE = ".updateByExampleSelective";

    public UserInfoInterceptor() {
        log.info("\u521d\u59cb\u5316\u7ec4\u4ef6:[Mybatis\u81ea\u52a8\u6ce8\u5165\u7528\u6237\u4fe1\u606f]");
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        try {
            DefaultSqlSession.StrictMap strictMap;
            Object listObj;
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            Map<Object, Object> replaceParameter = null;
            if (ms.getId().endsWith(INSERT)) {
                replaceParameter = this.replaceInsertUserInfo((Map<Object, Object>)new BeanMap(parameter), LocalDateTime.now());
            } else if (ms.getId().endsWith(UPDATE) || ms.getId().endsWith(UPDATE_SELECTIVE)) {
                replaceParameter = this.replaceUpdateUserInfo((Map<Object, Object>)new BeanMap(parameter), LocalDateTime.now());
            } else if (ms.getId().endsWith(UPDATE_EXAMPLE) || ms.getId().endsWith(UPDATE_EXAMPLE_SELECTIVE)) {
                MapperMethod.ParamMap paramMap;
                Object record;
                Map<Object, Object> newParam;
                if (parameter instanceof MapperMethod.ParamMap && (newParam = this.replaceUpdateUserInfo((Map<Object, Object>)new BeanMap(record = (paramMap = (MapperMethod.ParamMap)parameter).get((Object)"record")), LocalDateTime.now())) != null) {
                    paramMap.put((Object)"record", newParam);
                }
            } else if (ms.getId().endsWith(INSERT_LIST) && parameter instanceof DefaultSqlSession.StrictMap && (listObj = (strictMap = (DefaultSqlSession.StrictMap)parameter).get((Object)"list")) instanceof List) {
                LocalDateTime time = LocalDateTime.now();
                List list = (List)listObj;
                for (Object obj : list) {
                    this.replaceInsertUserInfo((Map<Object, Object>)new BeanMap(obj), time);
                }
            }
            if (replaceParameter != null) {
                args[1] = replaceParameter;
            }
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return method.invoke(target, args);
    }

    private Map<Object, Object> replaceUpdateUserInfo(Map<Object, Object> paramMap, LocalDateTime time) {
        HashSet<Boolean> replaceFlag = new HashSet<Boolean>();
        this.replace(replaceFlag, paramMap, "updateUser", RpcContextUtils.getUserId());
        this.replace(replaceFlag, paramMap, "updateUsertype", RpcContextUtils.getUserType());
        this.replace(replaceFlag, paramMap, "updateName", RpcContextUtils.getChineseName());
        this.replace(replaceFlag, paramMap, "updateUserName", RpcContextUtils.getChineseName());
        this.replace(replaceFlag, paramMap, "updateDate", time.toLocalDate());
        this.replace(replaceFlag, paramMap, "updateTime", time);
        if (replaceFlag.contains(true)) {
            log.info("replaceUpdateUserInfo");
            return paramMap;
        }
        return null;
    }

    private Map<Object, Object> replaceInsertUserInfo(Map<Object, Object> paramMap, LocalDateTime time) {
        HashSet<Boolean> replaceFlag = new HashSet<Boolean>();
        this.replace(replaceFlag, paramMap, "createUser", RpcContextUtils.getUserId());
        this.replace(replaceFlag, paramMap, "createUsertype", RpcContextUtils.getUserType());
        this.replace(replaceFlag, paramMap, "createName", RpcContextUtils.getChineseName());
        this.replace(replaceFlag, paramMap, "createUserName", RpcContextUtils.getChineseName());
        this.replace(replaceFlag, paramMap, "createDate", time.toLocalDate());
        this.replace(replaceFlag, paramMap, "createTime", time);
        if (replaceFlag.contains(true)) {
            return paramMap;
        }
        return null;
    }

    private void replace(Set<Boolean> booleanSet, Map<Object, Object> paramMap, String key, Object val) {
        if (paramMap.containsKey(key) && paramMap.get(key) == null) {
            paramMap.put(key, val);
            log.info("set {}:{}", (Object)key, val);
            booleanSet.add(true);
        }
        booleanSet.add(false);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

