/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.rocogz.common.api.enums.SerialNoRuleEnum;
import com.rocogz.common.dao.SerialNoMapper;
import com.rocogz.common.entity.SerialNo;
import com.rocogz.common.lock.DistributedLock;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import tk.mybatis.mapper.entity.Example;

@Service
public class SerialNoService {
    private static final Logger log = LoggerFactory.getLogger(SerialNoService.class);
    private static final String FLAG_PREFIX = "GENERATE_NO";
    private static final int CAPACITY_THRESHOLD = 500;
    private static final Long BATCH_SIZE = 1000L;
    private static final int RETRY_LIMIT = 3;
    private static final long RETRY_TIME = 3000L;
    private SerialNoMapper serialNoMapper;
    private StringRedisTemplate redisTemplate;
    private DistributedLock distributedLock;

    public SerialNoService(SerialNoMapper serialNoMapper, StringRedisTemplate redisTemplate, DistributedLock distributedLock) {
        log.info("\u521d\u59cb\u5316\u7ec4\u4ef6:[\u53d1\u53f7\u5668]");
        this.serialNoMapper = serialNoMapper;
        this.redisTemplate = redisTemplate;
        this.distributedLock = distributedLock;
    }

    public Map<String, Boolean> clearCode(String typeEnum) {
        HashMap maps = Maps.newHashMap();
        for (RedisKey key : RedisKey.values()) {
            boolean result = this.redisTemplate.delete((Object)this.getRedisKey(typeEnum, key));
            maps.put(key.name(), result);
        }
        log.info("clear:[{}]", (Object)maps);
        return maps;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public String generateCode(String typeEnum) {
        int retryNum = 0;
        SerialNo cacheSerialNo = this.getCacheAvailableSerialNo(typeEnum, retryNum);
        Assert.notNull((Object)cacheSerialNo, (String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u5e8f\u53f7");
        String seqKey = this.getRedisKey(typeEnum, RedisKey.CUR_SEQ_NO_PREFIX);
        Long seqNo = this.redisTemplate.opsForValue().increment((Object)seqKey);
        this.checkSeq(seqNo, cacheSerialNo, typeEnum);
        this.checkCapacity(seqNo, cacheSerialNo, typeEnum);
        return this.aggregateResult(seqNo, cacheSerialNo);
    }

    private String aggregateResult(Long seqNo, SerialNo cacheSerialNo) {
        StringBuilder result = new StringBuilder();
        result.append(cacheSerialNo.getSeqPrefix());
        result.append(this.formatPattern(cacheSerialNo.getLastestDate(), cacheSerialNo.getFormatPattern()));
        result.append(StringUtils.leftPad((String)seqNo.toString(), (int)cacheSerialNo.getSeqLpadLength(), (String)"0"));
        String resultStr = result.toString();
        log.info("generateCode:{}", (Object)resultStr);
        return resultStr;
    }

    private String formatPattern(LocalDate lastDate, String pattern) {
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            if (lastDate == null) {
                lastDate = LocalDate.now();
            }
            return pattern.replace("%Y", String.valueOf(lastDate.getYear())).replace("%m", StringUtils.leftPad((String)String.valueOf(lastDate.getMonthValue()), (int)2, (String)"0")).replace("%d", StringUtils.leftPad((String)String.valueOf(lastDate.getDayOfMonth()), (int)2, (String)"0"));
        }
        return "";
    }

    private void checkCapacity(Long seqNo, SerialNo cacheSerialNo, String typeEnum) {
        long size = cacheSerialNo.getSeqNo() - seqNo;
        log.info("[{}]:\u7f13\u5b58\u4e0a\u9650:[{}],\u5269\u4f59\u6570:[{}]", new Object[]{typeEnum, cacheSerialNo.getSeqNo(), size});
        if (size < 500L) {
            SerialNo serialNo = (SerialNo)this.serialNoMapper.selectByPrimaryKey(typeEnum);
            Assert.notNull((Object)serialNo, (String)("\u83b7\u53d6\u5e8f\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\uff1a" + typeEnum));
            if (serialNo.getVersion().equals(cacheSerialNo.getVersion())) {
                SerialNo result = this.capacitySerialNo(serialNo, typeEnum);
                if (result != null) {
                    log.info("\u6269\u5bb9\u5b8c\u6210:[{}]", (Object)typeEnum);
                }
            } else {
                log.info("\u7248\u672c[{}]:[{}]\u4e0d\u4e00\u81f4\uff0c \u4e0d\u6269\u5bb9", (Object)cacheSerialNo.getVersion(), (Object)serialNo.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerialNo capacitySerialNo(final SerialNo serialNo, final String typeEnum) {
        String lockKey = this.getRedisKey(typeEnum, RedisKey.CAPACITY_SEQ_NO_PREFIX);
        boolean tryLock = this.distributedLock.lock(lockKey, 1500L, 0);
        if (tryLock) {
            log.info("\u5f00\u59cb\u6269\u5bb9");
            try {
                Long originVersion = serialNo.getVersion();
                final Long originSeqNo = serialNo.getSeqNo() == null ? 0L : serialNo.getSeqNo();
                Long newSeqNo = originSeqNo + BATCH_SIZE;
                Example example = new Example(SerialNo.class);
                example.createCriteria().andEqualTo("version", (Object)originVersion).andEqualTo("seqCode", (Object)serialNo.getSeqCode());
                serialNo.setVersion(originVersion + 1L);
                serialNo.setSeqNo(newSeqNo);
                serialNo.setLastestDate(LocalDate.now());
                serialNo.setSeqVal(this.aggregateResult(newSeqNo, serialNo));
                int count = this.serialNoMapper.updateByExample(serialNo, example);
                if (count > 0) {
                    this.redisTemplate.execute((RedisCallback)new RedisCallback<List<Object>>(){

                        public List<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.openPipeline();
                            connection.setNX(RedisSerializer.string().serialize((Object)SerialNoService.this.getRedisKey(typeEnum, RedisKey.CUR_SEQ_NO_PREFIX)), RedisSerializer.string().serialize((Object)originSeqNo.toString()));
                            SerialNoService.this.setRedisConf(connection, serialNo, typeEnum);
                            return connection.closePipeline();
                        }
                    });
                    log.info("[{}]:\u7f13\u5b58\u4e0a\u9650\uff1a[{}], \u6269\u5bb9\u5b8c\u6bd5", (Object)serialNo.getSeqCode(), (Object)serialNo.getSeqNo());
                    SerialNo serialNo2 = serialNo;
                    return serialNo2;
                }
                log.error("\u6269\u5bb9\u4fee\u6539\u5e8f\u53f7\u5931\u8d25");
            }
            finally {
                this.distributedLock.releaseLock(lockKey);
            }
        } else {
            log.info("\u83b7\u9501\u5931\u8d25\uff0c\u8df3\u8fc7\u6269\u5bb9");
        }
        return null;
    }

    private void checkSeq(Long seq, SerialNo serialNo, String typeEnum) {
        try {
            Assert.notNull((Object)seq, (String)"\u751f\u6210\u5e8f\u53f7\u4e3anull");
            Assert.isTrue((seq > 0L ? 1 : 0) != 0, (String)"\u751f\u6210\u5e8f\u53f7\u4e3a\u8d1f\u6570");
            Assert.isTrue((seq <= serialNo.getSeqNo() ? 1 : 0) != 0, (String)"\u751f\u6210\u5e8f\u53f7\u8d85\u8fc7\u4e0a\u9650");
            Assert.isTrue((seq.toString().length() <= serialNo.getSeqLpadLength() ? 1 : 0) != 0, (String)"\u751f\u6210\u5e8f\u53f7\u8d85\u8fc7\u9650\u5236\u957f\u5ea6");
        }
        catch (Exception e) {
            this.clearCacheSerialNo(typeEnum);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerialNo initSerialNo(String typeEnum, int retryNum) {
        log.info("\u521d\u59cb\u5316");
        String lockKey = this.getRedisKey(typeEnum, RedisKey.INIT_SEQ_NO_PREFIX);
        boolean tryLock = this.distributedLock.lock(lockKey, 15000L, 0);
        if (tryLock) {
            try {
                SerialNo serialNo = (SerialNo)this.serialNoMapper.selectByPrimaryKey(typeEnum);
                Assert.notNull((Object)serialNo, (String)("\u83b7\u53d6\u5e8f\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\uff1a" + typeEnum));
                SerialNo check = this.checkRestGet(serialNo, typeEnum, retryNum);
                if (check != null) {
                    SerialNo serialNo2 = check;
                    return serialNo2;
                }
                SerialNo serialNo3 = this.capacitySerialNo(serialNo, typeEnum);
                return serialNo3;
            }
            finally {
                this.distributedLock.releaseLock(lockKey);
            }
        }
        return this.retry(typeEnum, retryNum);
    }

    private void clearCacheSerialNo(final String typeEnum) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<List<Object>>(){

            public List<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                connection.openPipeline();
                connection.del((byte[][])new byte[][]{RedisSerializer.string().serialize((Object)SerialNoService.this.getRedisKey(typeEnum, RedisKey.SEQ_NO_CONF_PREFIX))});
                connection.del((byte[][])new byte[][]{RedisSerializer.string().serialize((Object)SerialNoService.this.getRedisKey(typeEnum, RedisKey.CUR_SEQ_NO_PREFIX))});
                return connection.closePipeline();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerialNo resetSerialNo(final String typeEnum, int retryNum) {
        log.info("\u91cd\u7f6e\u5e8f\u53f7");
        String lockKey = this.getRedisKey(typeEnum, RedisKey.REST_SEQ_NO_PREFIX);
        boolean tryLock = this.distributedLock.lock(lockKey, 15000L, 0);
        if (tryLock) {
            try {
                final SerialNo serialNo = (SerialNo)this.serialNoMapper.selectByPrimaryKey(typeEnum);
                Assert.notNull((Object)serialNo, (String)("\u83b7\u53d6\u5e8f\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\uff1a" + typeEnum));
                Long originVersion = serialNo.getVersion();
                serialNo.setVersion(originVersion + 1L);
                serialNo.setSeqNo(BATCH_SIZE);
                serialNo.setLastestDate(LocalDate.now());
                serialNo.setSeqVal(this.aggregateResult(BATCH_SIZE, serialNo));
                Example example = new Example(SerialNo.class);
                example.createCriteria().andEqualTo("seqCode", (Object)serialNo.getSeqCode()).andEqualTo("version", (Object)originVersion);
                example.and().andNotEqualTo("lastestDate", (Object)LocalDate.now()).orIsNull("lastestDate");
                int count = this.serialNoMapper.updateByExample(serialNo, example);
                if (count > 0) {
                    this.redisTemplate.execute((RedisCallback)new RedisCallback<List<Object>>(){

                        public List<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.openPipeline();
                            connection.set(RedisSerializer.string().serialize((Object)SerialNoService.this.getRedisKey(typeEnum, RedisKey.CUR_SEQ_NO_PREFIX)), RedisSerializer.string().serialize((Object)"0"));
                            SerialNoService.this.setRedisConf(connection, serialNo, typeEnum);
                            return connection.closePipeline();
                        }
                    });
                    SerialNo serialNo2 = serialNo;
                    return serialNo2;
                }
                log.info("\u91cd\u7f6e\u5e8f\u53f7\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
            finally {
                this.distributedLock.releaseLock(lockKey);
            }
        } else {
            return this.retry(typeEnum, retryNum);
        }
        return null;
    }

    private void setRedisConf(RedisConnection connection, SerialNo serialNo, String typeEnum) {
        byte[] conf = RedisSerializer.string().serialize((Object)JSON.toJSONString((Object)serialNo));
        Long expire = this.getExpireSeconds(serialNo.getSeqNoResetRule());
        if (expire != null) {
            log.info(" rule:{},  expire:{}", (Object)serialNo.getSeqNoResetRule(), (Object)expire);
            connection.setEx(RedisSerializer.string().serialize((Object)this.getRedisKey(typeEnum, RedisKey.SEQ_NO_CONF_PREFIX)), expire.longValue(), conf);
        } else {
            connection.set(RedisSerializer.string().serialize((Object)this.getRedisKey(typeEnum, RedisKey.SEQ_NO_CONF_PREFIX)), conf);
        }
    }

    private Long getExpireSeconds(String restRuleStr) {
        SerialNoRuleEnum restRule = SerialNoRuleEnum.getByName((String)restRuleStr);
        if (restRule != null) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime lastDayTime = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
            LocalDateTime end = null;
            switch (restRule) {
                case DAY: {
                    end = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
                    break;
                }
                case MONTH: {
                    end = lastDayTime.with(TemporalAdjusters.lastDayOfMonth());
                    break;
                }
                case YEAR: {
                    end = lastDayTime.with(TemporalAdjusters.lastDayOfYear());
                    break;
                }
                default: {
                    return null;
                }
            }
            return Duration.between(now, end).toMillis() / 1000L;
        }
        return null;
    }

    private SerialNo retry(String typeEnum, int retryNum) {
        try {
            log.info("\u8fdb\u5165\u4f11\u7720\u7b49\u5f85\u91cd\u8bd5");
            Thread.sleep(3000L);
            if (retryNum < 3) {
                return this.getCacheAvailableSerialNo(typeEnum, retryNum);
            }
            log.info("\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570");
        }
        catch (InterruptedException e) {
            log.error("\u4f11\u7720\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    private SerialNo getCacheAvailableSerialNo(String typeEnum, int retryNum) {
        if (++retryNum > 1) {
            log.info("\u7b2c{}\u6b21\u83b7\u53d6\u914d\u7f6e", (Object)retryNum);
        }
        String confKey = this.getRedisKey(typeEnum, RedisKey.SEQ_NO_CONF_PREFIX);
        String jsonConfStr = (String)this.redisTemplate.opsForValue().get((Object)confKey);
        if (StringUtils.isBlank((CharSequence)jsonConfStr)) {
            return this.initSerialNo(typeEnum, retryNum);
        }
        try {
            SerialNo serialNo = (SerialNo)JSON.parseObject((String)jsonConfStr, SerialNo.class);
            SerialNo check = this.checkRestGet(serialNo, typeEnum, retryNum);
            if (check != null) {
                return check;
            }
            return serialNo;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5e8f\u53f7\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            this.clearCacheSerialNo(typeEnum);
            return this.initSerialNo(typeEnum, retryNum);
        }
    }

    private SerialNo checkRestGet(SerialNo serialNo, String typeEnum, int retryNum) {
        SerialNoRuleEnum resetRule = SerialNoRuleEnum.getByName((String)serialNo.getSeqNoResetRule());
        if (resetRule != null) {
            LocalDate now = LocalDate.now();
            int nowYear = now.getYear();
            int nowMonth = now.getMonthValue();
            int nowDay = now.getDayOfMonth();
            switch (resetRule) {
                case YEAR: {
                    if (serialNo.getLastestDate() != null && nowYear == serialNo.getLastestDate().getYear()) break;
                    return this.resetSerialNo(typeEnum, retryNum);
                }
                case MONTH: {
                    if (serialNo.getLastestDate() != null && nowYear == serialNo.getLastestDate().getYear() && nowMonth == serialNo.getLastestDate().getMonthValue()) break;
                    return this.resetSerialNo(typeEnum, retryNum);
                }
                case DAY: {
                    if (serialNo.getLastestDate() != null && nowYear == serialNo.getLastestDate().getYear() && nowMonth == serialNo.getLastestDate().getMonthValue() && nowDay == serialNo.getLastestDate().getDayOfMonth()) break;
                    return this.resetSerialNo(typeEnum, retryNum);
                }
                case FOREVER: {
                    break;
                }
                default: {
                    log.info("\u9ed8\u8ba4\u4e0d\u91cd\u7f6e");
                }
            }
        }
        return null;
    }

    private String getRedisKey(String type, RedisKey redisKey) {
        return String.join((CharSequence)":", FLAG_PREFIX, redisKey.name(), type);
    }

    static enum RedisKey {
        CUR_SEQ_NO_PREFIX,
        SEQ_NO_CONF_PREFIX,
        INIT_SEQ_NO_PREFIX,
        REST_SEQ_NO_PREFIX,
        CAPACITY_SEQ_NO_PREFIX;

    }
}

